/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol;

import com.microsoft.tfs.core.clients.versioncontrol.ClientLocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.GetItemsOptions;
import com.microsoft.tfs.core.clients.versioncontrol.ILocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.IPopulatableLocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.UpdateLocalVersionQueueOptions;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceOptions;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.WebServiceLayer;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.AllTablesTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BaselineFileGUIDComparer;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BaselineFolderCollection;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BaselineRequest;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalDataAccessLayer;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalPendingChangesTable;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalVersionTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceProperties;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLocalItem;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLock;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspacePropertiesLocalVersionTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspacePropertiesTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceVersionTable;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.DeletedState;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.ChangesetVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Closable;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateLocalVersionQueue
implements Closable {
    private static final Log log = LogFactory.getLog(UpdateLocalVersionQueue.class);
    private static final int COUNT_THRESHOLD = 200;
    private static final int SLEEP_TIME_MILLISECONDS = 2000;
    private static final int DEFAULT_FLUSH_TRIGGER_LEVEL = 400;
    private static final int DEFAULT_MAXIMUM_LEVEL = 1600;
    private static final int DEFAULT_TIME_TRIGGER_MILLISECONDS = 15000;
    private final Workspace workspace;
    private final UpdateLocalVersionQueueOptions options;
    private final WorkspaceLock wLock;
    private long timerMillis;
    private final Object flushLock = new Object();
    private volatile boolean flushing;
    private boolean closed;
    private Set<byte[]> persistedDisplacedBaselines;
    private List<ILocalVersionUpdate> pendingAcks;
    private List<ILocalVersionUpdate> pendingUpdates = new ArrayList<ILocalVersionUpdate>(200);
    private final int flushTriggerLevel;
    private final int maximumLevel;
    private final int timeTriggerInMilliseconds;

    public UpdateLocalVersionQueue(Workspace workspace) {
        this(workspace, UpdateLocalVersionQueueOptions.UPDATE_BOTH, null);
    }

    public UpdateLocalVersionQueue(Workspace workspace, UpdateLocalVersionQueueOptions options) {
        this(workspace, options, null);
    }

    public UpdateLocalVersionQueue(Workspace workspace, UpdateLocalVersionQueueOptions options, WorkspaceLock wLock) {
        this(workspace, options, wLock, 400, 1600, 15000);
    }

    public UpdateLocalVersionQueue(Workspace workspace, UpdateLocalVersionQueueOptions options, WorkspaceLock wLock, int flushTriggerLevel, int maximumLevel, int timeTriggerInMilliseconds) {
        Check.isTrue(flushTriggerLevel < maximumLevel, "flushTriggerLevel < maximumLevel");
        Check.isTrue(timeTriggerInMilliseconds > 0, "timeTriggerInMilliseconds > 0");
        this.flushTriggerLevel = flushTriggerLevel;
        this.maximumLevel = maximumLevel;
        this.timeTriggerInMilliseconds = timeTriggerInMilliseconds;
        this.workspace = workspace;
        this.wLock = wLock;
        this.pendingUpdates = new ArrayList<ILocalVersionUpdate>(maximumLevel);
        this.options = options;
        if (options.contains(UpdateLocalVersionQueueOptions.UPDATE_LOCAL) && WorkspaceLocation.LOCAL == workspace.getLocation()) {
            if (options.contains(UpdateLocalVersionQueueOptions.UPDATE_SERVER)) {
                this.pendingAcks = new ArrayList<ILocalVersionUpdate>(maximumLevel);
            }
            this.persistedDisplacedBaselines = new TreeSet<byte[]>(new BaselineFileGUIDComparer());
        }
    }

    public void queueUpdate(String sourceServerItem, int itemId, String targetLocalItem, int localVersion, PropertyValue[] properties) {
        this.queueUpdate(new ClientLocalVersionUpdate(sourceServerItem, itemId, targetLocalItem, localVersion, properties));
    }

    public void queueUpdate(String sourceServerItem, int itemId, String targetLocalItem, int localVersion, Calendar localVersionCheckinDate, int encoding, byte[] baselineHashValue, long baselineFileLength, PropertyValue[] properties) {
        this.queueUpdate(new ClientLocalVersionUpdate(sourceServerItem, itemId, targetLocalItem, localVersion, localVersionCheckinDate, encoding, baselineHashValue, baselineFileLength, null, null, properties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueUpdate(ILocalVersionUpdate update) {
        Check.notNull(update, "update");
        if (WorkspaceLocation.SERVER == this.workspace.getLocation() && !update.isSendToServer()) {
            return;
        }
        Check.isTrue(WorkspaceLocation.LOCAL == this.workspace.getLocation() || 0 != update.getItemID(), "Local version updates queued for server workspaces must have an item ID to communicate with downlevel servers");
        boolean flush = false;
        List<ILocalVersionUpdate> list = this.pendingUpdates;
        synchronized (list) {
            boolean timeout = false;
            while (this.pendingUpdates.size() >= this.maximumLevel && (!timeout || this.flushing)) {
                long beforeWaitMillis = System.currentTimeMillis();
                try {
                    this.pendingUpdates.wait(2000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                long elapsedMillis = System.currentTimeMillis() - beforeWaitMillis;
                timeout = elapsedMillis >= 2000L;
            }
            if (this.closed) {
                return;
            }
            if (0 == this.pendingUpdates.size()) {
                this.timerMillis = System.currentTimeMillis();
            }
            this.pendingUpdates.add(update);
            if (!(this.flushing || this.pendingUpdates.size() < this.flushTriggerLevel && System.currentTimeMillis() - this.timerMillis < (long)this.timeTriggerInMilliseconds)) {
                this.flushing = true;
                flush = true;
                this.timerMillis = System.currentTimeMillis();
            }
        }
        if (flush) {
            try {
                this.flush();
            }
            finally {
                this.flushing = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        List<ILocalVersionUpdate> list = this.pendingUpdates;
        synchronized (list) {
            this.closed = true;
        }
        this.flush();
        this.flushAcks();
        if (null != this.persistedDisplacedBaselines && this.persistedDisplacedBaselines.size() > 0) {
            if (null != this.wLock && null != this.wLock.getBaselineFolders()) {
                BaselineFolderCollection baselineFolders = this.wLock.getBaselineFolders();
                for (byte[] baselineFileGuid : this.persistedDisplacedBaselines) {
                    baselineFolders.deleteBaseline(baselineFileGuid);
                }
            } else {
                LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(this.workspace, this.wLock);
                try {
                    transaction.execute(new WorkspacePropertiesTransaction(){

                        @Override
                        public void invoke(LocalWorkspaceProperties wp) {
                            for (byte[] baselineFileGuid : UpdateLocalVersionQueue.this.persistedDisplacedBaselines) {
                                wp.deleteBaseline(baselineFileGuid);
                            }
                        }
                    });
                }
                finally {
                    try {
                        transaction.close();
                    }
                    catch (IOException e) {
                        throw new VersionControlException(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.flushLock;
        synchronized (object) {
            ILocalVersionUpdate[] updates = null;
            List<ILocalVersionUpdate> list = this.pendingUpdates;
            synchronized (list) {
                updates = this.pendingUpdates.toArray(new ILocalVersionUpdate[this.pendingUpdates.size()]);
            }
            if (this.options.contains(UpdateLocalVersionQueueOptions.UPDATE_LOCAL) && WorkspaceLocation.LOCAL == this.workspace.getLocation()) {
                this.ensureUpdatesFullyPopulated(updates);
            }
            try {
                this.downloadMissingBaselines(this.sendToServer(updates));
            }
            finally {
                list = this.pendingUpdates;
                synchronized (list) {
                    for (int i = updates.length - 1; i >= 0; --i) {
                        this.pendingUpdates.remove(0);
                    }
                    this.pendingUpdates.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureUpdatesFullyPopulated(final ILocalVersionUpdate[] updates) {
        final boolean setFileTimeToCheckin = this.workspace.getOptions().contains(WorkspaceOptions.SET_FILE_TO_CHECKIN);
        final ArrayList toFetchFromPendingChanges = new ArrayList();
        final TreeMap targetServerItemMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        final ArrayList toFetchFromQueryItems = new ArrayList();
        LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(this.workspace, this.wLock);
        try {
            transaction.execute(new WorkspacePropertiesLocalVersionTransaction(){

                @Override
                public void invoke(LocalWorkspaceProperties wp, WorkspaceVersionTable lv) {
                    for (ILocalVersionUpdate update : updates) {
                        if (!(update instanceof IPopulatableLocalVersionUpdate)) continue;
                        IPopulatableLocalVersionUpdate cUpdate = (IPopulatableLocalVersionUpdate)update;
                        WorkspaceLocalItem lvExisting = lv.getByServerItem(cUpdate.getSourceServerItem(), cUpdate.isCommitted());
                        if (null != lvExisting && lvExisting.getVersion() == cUpdate.getVersionLocal()) {
                            cUpdate.updateFrom(lvExisting);
                        }
                        if (cUpdate.isFullyPopulated(setFileTimeToCheckin)) continue;
                        if (null != cUpdate.getPendingChangeTargetServerItem()) {
                            toFetchFromPendingChanges.add(new ItemSpec(cUpdate.getPendingChangeTargetServerItem(), RecursionType.NONE));
                            targetServerItemMap.put(cUpdate.getPendingChangeTargetServerItem(), cUpdate);
                            continue;
                        }
                        toFetchFromQueryItems.add(cUpdate);
                    }
                }
            });
        }
        finally {
            try {
                transaction.close();
            }
            catch (IOException e) {
                throw new VersionControlException(e);
            }
        }
        if (toFetchFromPendingChanges.size() > 0) {
            PendingChange[] pendingChanges;
            Check.isTrue(this.options.contains(UpdateLocalVersionQueueOptions.UPDATE_SERVER), "Making a server call to fetch missing local version data during an offline operation");
            WebServiceLayer webServiceLayer = this.workspace.getClient().getWebServiceLayer();
            for (PendingChange pendingChange : pendingChanges = webServiceLayer.queryServerPendingChanges(this.workspace, toFetchFromPendingChanges.toArray(new ItemSpec[toFetchFromPendingChanges.size()]), true, this.workspace.getClient().mergeWithDefaultItemPropertyFilters(null))) {
                IPopulatableLocalVersionUpdate cUpdate = (IPopulatableLocalVersionUpdate)targetServerItemMap.get(pendingChange.getServerItem());
                if (cUpdate == null) {
                    log.warn((Object)"EnsureUpdatesFullyPopulated: Query did not return a PendingChange");
                    continue;
                }
                cUpdate.updateFrom(pendingChange);
                Check.isTrue(cUpdate.isFullyPopulated(setFileTimeToCheckin), "cUpdate.isFullyPopulated(setFileTimeToCheckin)");
                cUpdate.setDownloadURL(pendingChange.getDownloadURL());
            }
        }
        for (IPopulatableLocalVersionUpdate update : toFetchFromQueryItems) {
            Item[] arr$;
            int len$;
            int i$;
            GetItemsOptions options = GetItemsOptions.INCLUDE_SOURCE_RENAMES.combine(GetItemsOptions.UNSORTED).combine(GetItemsOptions.DOWNLOAD);
            ItemSet[] items = this.workspace.getClient().getItems(new ItemSpec[]{new ItemSpec(update.getSourceServerItem(), RecursionType.NONE)}, (VersionSpec)new ChangesetVersionSpec(update.getVersionLocal()), DeletedState.ANY, ItemType.ANY, options);
            if (items[0].getItems().length != 1) {
                log.warn((Object)"EnsureUpdatesFullyPopulated: Result missing");
            }
            if ((i$ = 0) >= (len$ = (arr$ = items[0].getItems()).length)) continue;
            Item item = arr$[i$];
            update.updateFrom(item);
            Check.isTrue(update.isFullyPopulated(setFileTimeToCheckin), "update.isFullyPopulated(setFileTimeToCheckin)");
            update.setDownloadURL(item.getDownloadURL());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadMissingBaselines(IPopulatableLocalVersionUpdate[] updates) {
        if (null == updates || 0 == updates.length) {
            return;
        }
        Check.isTrue(this.options.contains(UpdateLocalVersionQueueOptions.UPDATE_SERVER), "Making a server call to fetch a missing baseline during an offline operation");
        ArrayList<BaselineRequest> baselineRequests = new ArrayList<BaselineRequest>(updates.length);
        for (IPopulatableLocalVersionUpdate update : updates) {
            Item[] arr$;
            int len$;
            int i$;
            if (null != update.getDownloadURL()) {
                BaselineRequest request = BaselineRequest.fromDownloadUrl(update.getBaselineFileGUID(), update.getTargetLocalItem(), update.getDownloadURL(), update.getBaselineHashValue());
                baselineRequests.add(request);
                continue;
            }
            GetItemsOptions options = GetItemsOptions.INCLUDE_SOURCE_RENAMES.combine(GetItemsOptions.UNSORTED).combine(GetItemsOptions.DOWNLOAD);
            ItemSet[] items = this.workspace.getClient().getItems(new ItemSpec[]{new ItemSpec(update.getSourceServerItem(), RecursionType.NONE)}, (VersionSpec)new ChangesetVersionSpec(update.getVersionLocal()), DeletedState.ANY, ItemType.ANY, options);
            if (items[0].getItems().length != 1) {
                log.warn((Object)"DownloadMissingBaselines: Result missing");
            }
            if ((i$ = 0) >= (len$ = (arr$ = items[0].getItems()).length)) continue;
            Item item = arr$[i$];
            BaselineRequest request = BaselineRequest.fromDownloadUrl(update.getBaselineFileGUID(), update.getTargetLocalItem(), item.getDownloadURL(), item.getContentHashValue());
            baselineRequests.add(request);
        }
        final WorkspaceLock workspaceLock = this.wLock == null ? this.workspace.lock() : this.wLock;
        try {
            if (null == this.wLock) {
                LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(this.workspace);
                try {
                    transaction.execute(new WorkspacePropertiesTransaction(){

                        @Override
                        public void invoke(LocalWorkspaceProperties wp) {
                            workspaceLock.setBaselineFolders(new BaselineFolderCollection(UpdateLocalVersionQueue.this.workspace, wp.getBaselineFolders()));
                        }
                    });
                }
                finally {
                    try {
                        transaction.close();
                    }
                    catch (IOException e) {
                        throw new VersionControlException(e);
                    }
                }
            }
            workspaceLock.getBaselineFolders().processBaselineRequests(this.workspace, baselineRequests);
        }
        finally {
            if (null == this.wLock) {
                workspaceLock.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPopulatableLocalVersionUpdate[] sendToServer(final ILocalVersionUpdate[] updates) {
        Check.notNull(updates, "updates");
        log.debug((Object)MessageFormat.format("Sending {0} updates to the server (options={1})", Integer.toString(updates.length), this.options));
        if (updates.length == 0) {
            return null;
        }
        final AtomicReference updatesMissingBaselines = new AtomicReference();
        if (this.workspace.getLocation() == WorkspaceLocation.LOCAL && this.options.contains(UpdateLocalVersionQueueOptions.UPDATE_LOCAL)) {
            LocalWorkspaceTransaction baselineMaintTransaction = new LocalWorkspaceTransaction(this.workspace, this.wLock);
            try {
                baselineMaintTransaction.execute(new WorkspacePropertiesTransaction(){

                    @Override
                    public void invoke(LocalWorkspaceProperties wp) {
                        wp.doBaselineFolderMaintenance();
                    }
                });
            }
            finally {
                try {
                    baselineMaintTransaction.close();
                }
                catch (IOException e) {
                    throw new VersionControlException(e);
                }
            }
            UpdateLocalVersionQueue e = this;
            synchronized (e) {
                LocalWorkspaceTransaction updateTransaction = new LocalWorkspaceTransaction(this.workspace, this.wLock);
                try {
                    updateTransaction.execute(new AllTablesTransaction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void invoke(LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc) {
                            if (UpdateLocalVersionQueue.this.options.contains(UpdateLocalVersionQueueOptions.UPDATE_SERVER)) {
                                ILocalVersionUpdate[] acks;
                                List list = UpdateLocalVersionQueue.this.pendingAcks;
                                synchronized (list) {
                                    acks = UpdateLocalVersionQueue.this.pendingAcks.toArray(new ILocalVersionUpdate[UpdateLocalVersionQueue.this.pendingAcks.size()]);
                                    UpdateLocalVersionQueue.this.pendingAcks.clear();
                                }
                                if (acks.length > 0) {
                                    LocalDataAccessLayer.acknowledgeUpdateLocalVersion(lv, acks);
                                }
                            }
                            LocalDataAccessLayer.updateLocalVersion(UpdateLocalVersionQueue.this.workspace, wp, lv, pc, updates, UpdateLocalVersionQueue.this.persistedDisplacedBaselines, updatesMissingBaselines);
                        }
                    });
                }
                finally {
                    try {
                        updateTransaction.close();
                    }
                    catch (IOException e2) {
                        throw new VersionControlException(e2);
                    }
                }
            }
        }
        if (this.options.contains(UpdateLocalVersionQueueOptions.UPDATE_SERVER)) {
            this.workspace.getClient().getWebServiceLayer().updateLocalVersion(this.workspace.getName(), this.workspace.getOwnerName(), updates);
            if (this.options.contains(UpdateLocalVersionQueueOptions.UPDATE_LOCAL) && WorkspaceLocation.LOCAL == this.workspace.getLocation()) {
                List<ILocalVersionUpdate> list = this.pendingAcks;
                synchronized (list) {
                    for (ILocalVersionUpdate update : updates) {
                        this.pendingAcks.add(update);
                    }
                }
            }
        }
        return (IPopulatableLocalVersionUpdate[])updatesMissingBaselines.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushAcks() {
        if (this.options.equals(UpdateLocalVersionQueueOptions.UPDATE_BOTH) && WorkspaceLocation.LOCAL == this.workspace.getLocation()) {
            ILocalVersionUpdate[] acks;
            List<ILocalVersionUpdate> list = this.pendingAcks;
            synchronized (list) {
                acks = this.pendingAcks.toArray(new ILocalVersionUpdate[this.pendingAcks.size()]);
                this.pendingAcks.clear();
            }
            if (acks.length > 0) {
                LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(this.workspace, this.wLock);
                try {
                    transaction.execute(new LocalVersionTransaction(){

                        @Override
                        public void invoke(WorkspaceVersionTable lv) {
                            LocalDataAccessLayer.acknowledgeUpdateLocalVersion(lv, acks);
                        }
                    });
                }
                finally {
                    try {
                        transaction.close();
                    }
                    catch (IOException e) {
                        throw new VersionControlException(e);
                    }
                }
            }
        }
    }
}

