/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.exceptions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TeamFoundationServerExceptionProperties {
    private final Map<String, Object> properties;

    public TeamFoundationServerExceptionProperties() {
        this.properties = new HashMap<String, Object>();
    }

    public TeamFoundationServerExceptionProperties(Element exceptionPropertiesElement) {
        this.properties = this.parse(exceptionPropertiesElement);
    }

    public boolean hasObjectArrayProperty(String propertyName) {
        return this.properties.containsKey(propertyName) && this.properties.get(propertyName) instanceof Object[];
    }

    public boolean hasIntProperty(String propertyName) {
        return this.properties.containsKey(propertyName) && this.properties.get(propertyName) instanceof Integer;
    }

    public boolean hasBooleanProperty(String propertyName) {
        return this.properties.containsKey(propertyName) && this.properties.get(propertyName) instanceof Boolean;
    }

    public boolean hasStringProperty(String propertyName) {
        return this.properties.containsKey(propertyName) && this.properties.get(propertyName) instanceof String;
    }

    public Object[] getObjectArrayProperty(String propertyName) {
        if (this.hasObjectArrayProperty(propertyName)) {
            return (Object[])this.properties.get(propertyName);
        }
        return null;
    }

    public boolean getBooleanProperty(String propertyName) {
        if (this.hasBooleanProperty(propertyName)) {
            return (Boolean)this.properties.get(propertyName);
        }
        throw new IllegalStateException();
    }

    public int getIntProperty(String propertyName) {
        if (this.hasIntProperty(propertyName)) {
            return (Integer)this.properties.get(propertyName);
        }
        return 0;
    }

    public String getStringProperty(String propertyName) {
        if (this.hasStringProperty(propertyName)) {
            return (String)this.properties.get(propertyName);
        }
        return null;
    }

    public String[] getStringArrayProperty(String propertyName) {
        Object[] objects = this.getObjectArrayProperty(propertyName);
        ArrayList<String> strings = new ArrayList<String>();
        if (objects != null) {
            for (Object object : objects) {
                if (!(object instanceof String)) continue;
                strings.add((String)object);
            }
        }
        return strings.toArray(new String[strings.size()]);
    }

    private Map<String, Object> parse(Element propertiesElement) {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        NodeList propertyNodes = propertiesElement.getElementsByTagName("property");
        if (propertyNodes != null) {
            for (int i = 0; i < propertyNodes.getLength(); ++i) {
                Element propertyElement = (Element)propertyNodes.item(i);
                if (propertyElement == null) continue;
                String propertyName = propertyElement.getAttribute("name");
                Object propertyValue = TeamFoundationServerExceptionProperties.getPropertyValue(propertyElement);
                propertiesMap.put(propertyName, propertyValue);
            }
        }
        return propertiesMap;
    }

    private static Element getChildElement(Node parentNode, String childElementName) {
        Element parentElement;
        NodeList nodeList;
        if (parentNode.getNodeType() == 1 && (nodeList = (parentElement = (Element)parentNode).getElementsByTagName(childElementName)) != null && nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    private static Object getPropertyValue(Element propertyElement) {
        Element propertyValueElement = TeamFoundationServerExceptionProperties.getChildElement(propertyElement, "value");
        if (propertyValueElement != null) {
            String valueType = propertyValueElement.getAttribute("xsi:type");
            if (valueType.equals("ArrayOfAnyType")) {
                ArrayList<Object> list = new ArrayList<Object>();
                NodeList anyTypeNodes = propertyValueElement.getElementsByTagName("anyType");
                for (int i = 0; i < anyTypeNodes.getLength(); ++i) {
                    String content;
                    Element anyTypeElement = (Element)anyTypeNodes.item(i);
                    String type = anyTypeElement.getAttribute("xsi:type");
                    Object propertyValue = TeamFoundationServerExceptionProperties.getValue(type, content = anyTypeElement.getTextContent());
                    if (propertyValue == null) continue;
                    list.add(propertyValue);
                }
                return list.toArray(new Object[list.size()]);
            }
            return TeamFoundationServerExceptionProperties.getValue(valueType, propertyValueElement.getTextContent());
        }
        return null;
    }

    private static Object getValue(String type, String value) {
        if (type.equals("xsd:string")) {
            return value;
        }
        if (type.equals("xsd:boolean")) {
            return Boolean.valueOf(value);
        }
        if (type.equals("xsd:int")) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }
}

