/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LocalItemExclusionSet;
import com.microsoft.tfs.core.ws.runtime.xml.XMLConvert;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.xml.DOMUtils;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.dom.Element;

public class ExclusionSet {
    private Set<String> defaultExclusions = new HashSet<String>();
    private boolean defaultExclusionsOverwritten;
    private final Set<String> removedExclusions = new HashSet<String>();
    private GUID defaultExclusionWatermark;
    private Calendar lastDefaultExclusionUpdate;
    private static final String DEFAULT_EXCLUSIONS = "DefaultExclusions";
    private static final String EXCLUSION = "Exclusion";
    private static final String WATERMARK_ATTRIBUTE = "watermark";
    private static final String LAST_DEFAULT_EXCLUSION_UPDATE_ATTRIBUTE = "lastDefaultExclusionUpdate";

    public ExclusionSet() {
        String[] exclusions;
        this.setLastDefaultExclusionUpdate(null);
        this.setDefaultExclusionWatermark(GUID.EMPTY);
        String exclusionsList = "bin;bld;ClientBin;Debug;obj;Package;Release;TestResults;*.*~;*.appx;*.appxrecipe;*.cache;*.cer;*.class;*.dbmdl;*.dll;*.docstates;*.docstates.suo;*.err;*.exe;*.ilk;*.ipch;*.lastbuildstate;*.lce;*.ldf;*.lib;*.log;*.mdf;*.msscci;*.ncb;*.obj;*.opensdf;*.pch;*.pdb;*.pri;*.res;*.resources;*.sdf;*.suo;*.swp;*.temp;*.tfOrig*;*.tlog;*.tmp;*.trx;*.user;*.unsuccessfulbuild;*.v11.suo;*.vcxproj.user;*.vsix;*.vsmdi;*.vspscc;*.vssettings;*.vssscc;*.wrn;*.xap";
        for (String exclusion : exclusions = "bin;bld;ClientBin;Debug;obj;Package;Release;TestResults;*.*~;*.appx;*.appxrecipe;*.cache;*.cer;*.class;*.dbmdl;*.dll;*.docstates;*.docstates.suo;*.err;*.exe;*.ilk;*.ipch;*.lastbuildstate;*.lce;*.ldf;*.lib;*.log;*.mdf;*.msscci;*.ncb;*.obj;*.opensdf;*.pch;*.pdb;*.pri;*.res;*.resources;*.sdf;*.suo;*.swp;*.temp;*.tfOrig*;*.tlog;*.tmp;*.trx;*.user;*.unsuccessfulbuild;*.v11.suo;*.vcxproj.user;*.vsix;*.vsmdi;*.vspscc;*.vssettings;*.vssscc;*.wrn;*.xap".split(";")) {
            this.defaultExclusions.add(exclusion);
        }
    }

    public ExclusionSet(Element collectionElement) {
        this.setLastDefaultExclusionUpdate(null);
        this.setDefaultExclusionWatermark(GUID.EMPTY);
        Element defaultExclusionElement = DOMUtils.getFirstChildElement(collectionElement, DEFAULT_EXCLUSIONS);
        if (defaultExclusionElement != null) {
            Element[] exclusionElements;
            String updateValue;
            String watermarkValue = defaultExclusionElement.getAttribute(WATERMARK_ATTRIBUTE);
            if (watermarkValue != null && watermarkValue.length() > 0) {
                this.setDefaultExclusionWatermark(new GUID(watermarkValue));
            }
            if ((updateValue = defaultExclusionElement.getAttribute(LAST_DEFAULT_EXCLUSION_UPDATE_ATTRIBUTE)) != null && updateValue.length() > 0) {
                this.setLastDefaultExclusionUpdate(XMLConvert.toCalendar(updateValue, true));
            }
            for (Element exclusionElement : exclusionElements = DOMUtils.getChildElements(defaultExclusionElement, EXCLUSION)) {
                this.defaultExclusions.add(DOMUtils.getText(exclusionElement));
            }
        }
    }

    public GUID getDefaultExclusionWatermark() {
        return this.defaultExclusionWatermark;
    }

    private void setDefaultExclusionWatermark(GUID value) {
        this.defaultExclusionWatermark = value;
    }

    public Calendar getLastDefaultExclusionUpdate() {
        return this.lastDefaultExclusionUpdate;
    }

    private void setLastDefaultExclusionUpdate(Calendar value) {
        this.lastDefaultExclusionUpdate = value;
    }

    public boolean removeExclusion(String exclusion) {
        boolean somethingRemoved = this.defaultExclusions.remove(exclusion);
        if (somethingRemoved) {
            this.removedExclusions.add(exclusion);
        }
        return somethingRemoved;
    }

    public String[] getExclusions() {
        TreeSet<String> allExclusions = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String exclusion : this.defaultExclusions) {
            allExclusions.add(exclusion);
        }
        return allExclusions.toArray(new String[allExclusions.size()]);
    }

    public void setDefaultExclusions(LocalItemExclusionSet exclusionsSet) {
        if (!exclusionsSet.getWatermark().equals(this.getDefaultExclusionWatermark())) {
            this.defaultExclusions.clear();
            this.removedExclusions.remove("*.class");
            this.defaultExclusions.add("*.class");
            for (String exclusion : exclusionsSet.getExclusions()) {
                this.removedExclusions.remove(exclusion);
                this.defaultExclusions.add(exclusion);
            }
            this.defaultExclusionWatermark = exclusionsSet.getWatermark();
            this.defaultExclusionsOverwritten = true;
        }
        this.setLastDefaultExclusionUpdate(Calendar.getInstance());
    }

    public void save(Element collectionElement) {
        Element defaultsElement = DOMUtils.appendChild(collectionElement, DEFAULT_EXCLUSIONS);
        String watermark = this.getDefaultExclusionWatermark().getGUIDString();
        String date = XMLConvert.toString(this.getLastDefaultExclusionUpdate(), true, true);
        defaultsElement.setAttribute(WATERMARK_ATTRIBUTE, watermark);
        defaultsElement.setAttribute(LAST_DEFAULT_EXCLUSION_UPDATE_ATTRIBUTE, date);
        this.defaultExclusions.add("*.class");
        for (String exclusion : this.defaultExclusions) {
            DOMUtils.appendChildWithText(defaultsElement, EXCLUSION, exclusion);
        }
    }

    public void merge(ExclusionSet exclusionSetToMergeIn) {
        Set<String> defaultExclusions = this.defaultExclusionsOverwritten ? this.defaultExclusions : exclusionSetToMergeIn.defaultExclusions;
        for (String removal : this.removedExclusions) {
            defaultExclusions.remove(removal);
        }
        this.defaultExclusions = defaultExclusions;
    }

    public void markClean() {
        this.removedExclusions.clear();
        this.defaultExclusionsOverwritten = false;
    }
}

