/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.offline;

import com.microsoft.tfs.core.clients.versioncontrol.GetOptions;
import com.microsoft.tfs.core.clients.versioncontrol.PendChangesOptions;
import com.microsoft.tfs.core.clients.versioncontrol.WebServiceLevel;
import com.microsoft.tfs.core.clients.versioncontrol.offline.OfflineChange;
import com.microsoft.tfs.core.clients.versioncontrol.offline.OfflineChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LockLevel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.util.FileEncoding;
import java.util.ArrayList;
import java.util.List;

public class OfflinePender {
    private final Workspace workspace;
    private final OfflineChange[] offlineChanges;

    public OfflinePender(Workspace workspace, OfflineChange[] offlineChanges) {
        this.workspace = workspace;
        this.offlineChanges = offlineChanges;
    }

    public final int pendChanges() {
        String sourcePath;
        OfflineChange change;
        int i;
        int failures = 0;
        ArrayList<ItemSpec> undos = new ArrayList<ItemSpec>();
        ArrayList<String> adds = new ArrayList<String>();
        ArrayList<String> edits = new ArrayList<String>();
        ArrayList<String> deletes = new ArrayList<String>();
        for (i = 0; i < this.offlineChanges.length; ++i) {
            change = this.offlineChanges[i];
            sourcePath = change.getSourceLocalPath();
            String targetPath = change.getLocalPath();
            if (change.hasChangeType(OfflineChangeType.UNDO)) {
                undos.add(new ItemSpec(targetPath, RecursionType.NONE));
            }
            if (change.hasChangeType(OfflineChangeType.ADD)) {
                adds.add(sourcePath);
            }
            if (change.hasChangeType(OfflineChangeType.EDIT)) {
                edits.add(sourcePath);
            }
            if (!change.hasChangeType(OfflineChangeType.DELETE)) continue;
            deletes.add(sourcePath);
        }
        if (undos.size() > 0) {
            failures += this.pendUndos(undos);
        }
        if (adds.size() > 0) {
            failures += this.pendAdds(adds);
        }
        if (edits.size() > 0) {
            failures += this.pendEdits(edits);
        }
        if (deletes.size() > 0) {
            failures += this.pendDeletes(deletes);
        }
        if (this.workspace.getClient().getServiceLevel().getValue() >= WebServiceLevel.TFS_2012.getValue()) {
            for (i = 0; i < this.offlineChanges.length; ++i) {
                change = this.offlineChanges[i];
                sourcePath = change.getSourceLocalPath();
                if (!change.hasPropertyChange()) continue;
                failures += this.pendProperty(sourcePath, change.getPropertyValue());
            }
        }
        return failures;
    }

    private int pendUndos(List undos) {
        ItemSpec[] items = undos.toArray(new ItemSpec[undos.size()]);
        int undone = this.workspace.undo(items, GetOptions.combine(new GetOptions[]{GetOptions.NO_DISK_UPDATE, GetOptions.OVERWRITE}));
        return items.length - undone;
    }

    private int pendAdds(List adds) {
        String[] paths = adds.toArray(new String[adds.size()]);
        int pended = this.workspace.pendAdd(paths, false, FileEncoding.AUTOMATICALLY_DETECT, LockLevel.UNCHANGED, GetOptions.NONE, PendChangesOptions.NONE);
        return paths.length - pended;
    }

    private int pendEdits(List edits) {
        String[] paths = edits.toArray(new String[edits.size()]);
        int pended = this.workspace.pendEdit(paths, RecursionType.NONE, LockLevel.UNCHANGED, null, GetOptions.NONE, PendChangesOptions.FORCE_CHECK_OUT_LOCAL_VERSION);
        return paths.length - pended;
    }

    private int pendDeletes(List deletes) {
        String[] paths = deletes.toArray(new String[deletes.size()]);
        int pended = this.workspace.pendDelete(paths, RecursionType.NONE, LockLevel.UNCHANGED, GetOptions.NO_DISK_UPDATE, PendChangesOptions.NONE);
        return paths.length - pended;
    }

    private int pendProperty(String path, PropertyValue[] property) {
        int pended = this.workspace.pendPropertyChange(path, property, RecursionType.NONE, LockLevel.UNCHANGED);
        return 1 - pended;
    }
}

