/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.link;

import com.microsoft.tfs.core.clients.workitem.internal.link.LinkCollectionChangedListener;
import com.microsoft.tfs.core.clients.workitem.link.Link;
import com.microsoft.tfs.core.clients.workitem.link.LinkCollection;
import java.util.HashSet;
import java.util.Set;

public class LinkCollectionChangedListenerSupport {
    private final Set<LinkCollectionChangedListener> listeners = new HashSet<LinkCollectionChangedListener>();
    private final LinkCollection linkCollection;

    public LinkCollectionChangedListenerSupport(LinkCollection linkCollection) {
        this.linkCollection = linkCollection;
    }

    public synchronized void addListener(LinkCollectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(LinkCollectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void fireLinkAdded(Link link) {
        for (LinkCollectionChangedListener listener : this.listeners) {
            listener.linkAdded(link, this.linkCollection);
        }
    }

    public synchronized void fireLinkRemoved(Link link) {
        for (LinkCollectionChangedListener listener : this.listeners) {
            listener.linkRemoved(link, this.linkCollection);
        }
    }

    public synchronized void fireLinkTargetsUpdated() {
        for (LinkCollectionChangedListener listener : this.listeners) {
            listener.linkTargetsUpdated(this.linkCollection);
        }
    }
}

