/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.query;

import com.microsoft.tfs.core.clients.workitem.internal.query.PageCallback;
import java.text.MessageFormat;

public class PagedCollection {
    private final Object[] objects;
    private int pageSize;
    private final PageCallback callback;
    private boolean pagedAny = false;

    public PagedCollection(int totalSize, int pageSize, PageCallback callback) {
        this.objects = new Object[totalSize];
        this.pageSize = pageSize;
        this.callback = callback;
    }

    public int getSize() {
        return this.objects.length;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (this.pagedAny) {
            throw new IllegalStateException("cannot change page size once paging begins");
        }
        this.pageSize = pageSize;
    }

    public Object getItem(int index) {
        if (index < 0 || index >= this.getSize()) {
            throw new IllegalArgumentException(MessageFormat.format("index [{0}] is outside the range of items (0,{1})", Integer.toString(index), Integer.toString(this.getSize())));
        }
        if (this.objects[index] == null) {
            Object[] newItems;
            this.pagedAny = true;
            int pageNumber = index / this.pageSize;
            int pageStart = pageNumber * this.pageSize;
            int pageLength = this.pageSize;
            if (pageStart + pageLength > this.getSize()) {
                pageLength = this.getSize() - pageStart;
            }
            if ((newItems = this.callback.pageInItems(pageStart, pageLength)) == null || newItems.length != pageLength) {
                throw new IllegalStateException("page callback returned bad itemset");
            }
            System.arraycopy(newItems, 0, this.objects, pageStart, pageLength);
        }
        return this.objects[index];
    }

    public boolean hasPagedAny() {
        return this.pagedAny;
    }
}

