/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.query;

import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.query.StoredQueryImpl;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.GetStoredQueriesRowSetHandler;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.RowSetParseHandler;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.RowSetParser;
import com.microsoft.tfs.core.clients.workitem.query.StoredQuery;
import com.microsoft.tfs.core.ws.runtime.types.DOMAnyContentType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StoredQueryBucket {
    private static final Log log = LogFactory.getLog(StoredQueryBucket.class);
    private final int projectId;
    private final List<StoredQuery> queries = new ArrayList<StoredQuery>();
    private long rowVersion;
    private final WITContext witContext;

    public StoredQueryBucket(int projectId, WITContext witContext) {
        this.projectId = projectId;
        this.witContext = witContext;
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("created a new StoredQueryBucket: {0}", this.toString()));
        }
    }

    public String toString() {
        return MessageFormat.format("p={0} q={1} r={2} h={3}", Integer.toString(this.projectId), this.queries.size(), Long.toString(this.rowVersion), Integer.toHexString(System.identityHashCode(this)));
    }

    public void add(StoredQueryImpl storedQuery) {
        if (!this.queries.contains(storedQuery)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)MessageFormat.format("adding query [{0}]: {1}", storedQuery, this.toString()));
            }
            this.queries.add(storedQuery);
        }
    }

    public void refresh() {
        DOMAnyContentType payload = this.witContext.isVersion2() ? (DOMAnyContentType)this.witContext.getProxy().getStoredQueries(this.rowVersion, this.projectId, new DOMAnyContentType()) : (this.witContext.isVersion3() ? (DOMAnyContentType)this.witContext.getProxy3().getStoredQueries(this.rowVersion, this.projectId, new DOMAnyContentType()) : (DOMAnyContentType)this.witContext.getProxy5().getStoredQueries(this.rowVersion, this.projectId, new DOMAnyContentType()));
        RowSetParser parser = new RowSetParser();
        GetStoredQueriesRowSetHandler handler = new GetStoredQueriesRowSetHandler(this.witContext);
        parser.parse(payload.getElements()[0], (RowSetParseHandler)handler);
        StoredQueryImpl[] serverQueries = handler.getQueries();
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("refresh, got response length {0} from GetStoredQueries: {1}", serverQueries.length, this.toString()));
        }
        for (int i = 0; i < serverQueries.length; ++i) {
            if (serverQueries[i].getRowVersion() > this.rowVersion) {
                this.rowVersion = serverQueries[i].getRowVersion();
            }
            if (serverQueries[i].isDeleted()) {
                this.remove(serverQueries[i]);
                this.witContext.getQueryProvider().getQueryMap().remove(serverQueries[i].getQueryGUID());
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)MessageFormat.format("refresh, deleted query [{0}]: {1}", serverQueries[i], this.toString()));
                continue;
            }
            if (this.witContext.getQueryProvider().getQueryMap().containsKey(serverQueries[i].getQueryGUID())) {
                this.remove(serverQueries[i]);
                this.witContext.getQueryProvider().getQueryMap().remove(serverQueries[i].getQueryGUID());
                if (log.isDebugEnabled()) {
                    log.debug((Object)MessageFormat.format("refresh, got update for existing query [{0}]: {1}", serverQueries[i].getQueryGUID(), this.toString()));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)MessageFormat.format("refresh, got new query [{0}]: {1}", serverQueries[i], this.toString()));
            }
            this.add(serverQueries[i]);
            this.witContext.getQueryProvider().getQueryMap().put(serverQueries[i].getQueryGUID(), serverQueries[i]);
        }
        Collections.sort(this.queries);
    }

    public void remove(StoredQueryImpl query) {
        if (this.queries.remove(query) && log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("deleted query [{0}]: {1}", query, this.toString()));
        }
    }

    public List<StoredQuery> getQueryList() {
        return this.queries;
    }
}

