/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.query;

import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.project.ProjectImpl;
import com.microsoft.tfs.core.clients.workitem.internal.query.StoredQueryBucket;
import com.microsoft.tfs.core.clients.workitem.internal.query.StoredQueryImpl;
import com.microsoft.tfs.core.clients.workitem.internal.query.StoredQueryProviderImpl;
import com.microsoft.tfs.core.clients.workitem.query.InvalidQueryTextException;
import com.microsoft.tfs.core.clients.workitem.query.QueryScope;
import com.microsoft.tfs.core.clients.workitem.query.StoredQuery;
import com.microsoft.tfs.core.clients.workitem.query.StoredQueryCollection;
import com.microsoft.tfs.util.GUID;
import java.util.ArrayList;
import java.util.List;

public class StoredQueryCollectionImpl
implements StoredQueryCollection {
    private final ProjectImpl project;
    private final int projectId;
    private StoredQueryBucket queryBucket;
    private List<StoredQuery> queryList;
    private StoredQueryProviderImpl queryProvider;
    private final WITContext witContext;

    public StoredQueryCollectionImpl(ProjectImpl project, WITContext witContext) {
        this.project = project;
        this.projectId = project.getID();
        this.witContext = witContext;
        this.initialize();
    }

    @Override
    public void add(StoredQuery storedQuery) throws InvalidQueryTextException {
        if (storedQuery == null) {
            throw new IllegalArgumentException("storedQuery must not be null");
        }
        if (storedQuery.isSaved()) {
            throw new IllegalArgumentException("the input stored query is already saved");
        }
        StoredQueryImpl internalQuery = (StoredQueryImpl)storedQuery;
        internalQuery.projectId = this.projectId;
        internalQuery.witContext = this.witContext;
        internalQuery.queryProvider = this.queryProvider;
        internalQuery.project = this.project;
        this.queryProvider.addStoredQuery(internalQuery);
        this.project.notifyModicationListeners();
    }

    @Override
    public StoredQuery getQuery(int index) {
        StoredQueryBucket bucket1 = this.queryProvider.getQueryBucket(this.projectId);
        return bucket1.getQueryList().get(index);
    }

    @Override
    public void refresh() {
        this.queryProvider.refresh(this.projectId);
    }

    @Override
    public void remove(StoredQuery storedQuery) {
        if (storedQuery == null) {
            throw new IllegalArgumentException("storedQuery must not be null");
        }
        this.queryProvider.deleteStoredQuery((StoredQueryImpl)storedQuery);
        this.project.notifyModicationListeners();
    }

    @Override
    public int size() {
        return this.queryProvider.getQueryBucket(this.projectId).getQueryList().size();
    }

    @Override
    public StoredQuery getQueryByNameAndScope(String name, QueryScope scope) {
        StoredQuery[] queries = this.queryList.toArray(new StoredQuery[this.queryList.size()]);
        for (int i = 0; i < queries.length; ++i) {
            if (scope != null && queries[i].getQueryScope() != scope || !queries[i].getName().equalsIgnoreCase(name)) continue;
            return queries[i];
        }
        return null;
    }

    @Override
    public StoredQuery[] getQueriesByScope(QueryScope scope) {
        StoredQuery[] allQueries = this.queryList.toArray(new StoredQuery[this.queryList.size()]);
        ArrayList<StoredQuery> queriesByScope = new ArrayList<StoredQuery>();
        for (int i = 0; i < allQueries.length; ++i) {
            if (scope != null && allQueries[i].getQueryScope() != scope) continue;
            queriesByScope.add(allQueries[i]);
        }
        return queriesByScope.toArray(new StoredQuery[queriesByScope.size()]);
    }

    @Override
    public StoredQuery getByGUID(GUID guid) {
        return this.queryProvider.getQuery(guid);
    }

    private void initialize() {
        this.queryProvider = this.witContext.getQueryProvider();
        this.queryBucket = this.queryProvider.getQueryBucket(this.projectId);
        this.queryList = this.queryBucket.getQueryList();
    }

    public ProjectImpl getProjectInternal() {
        return this.project;
    }
}

