/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.type;

import com.microsoft.tfs.core.clients.workitem.WorkItemUtils;
import com.microsoft.tfs.core.clients.workitem.internal.type.WITypeConverter;
import com.microsoft.tfs.core.clients.workitem.internal.type.WITypeConverterException;
import com.microsoft.tfs.core.clients.workitem.internal.type.WIValueSource;
import java.text.MessageFormat;

public class WIDoubleTypeConverter
implements WITypeConverter {
    @Override
    public Object translate(Object input, WIValueSource valueSource) throws WITypeConverterException {
        Double translatedValue = null;
        if (input != null) {
            if (input instanceof Double) {
                translatedValue = (Double)input;
            } else if (input instanceof String) {
                String trimmed = ((String)input).trim();
                if (trimmed.length() == 0) {
                    return null;
                }
                try {
                    translatedValue = Double.valueOf(trimmed);
                }
                catch (NumberFormatException ex) {
                    throw new WITypeConverterException("unable to convert input to a double", ex);
                }
            } else {
                throw new WITypeConverterException(MessageFormat.format("unable to convert [{0}] to a double", input.getClass().getName()));
            }
        }
        return translatedValue;
    }

    @Override
    public String toString(Object data) {
        if (data == null) {
            return null;
        }
        return WorkItemUtils.objectToString(data);
    }
}

