/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.wiqlparse;

import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.DataType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.IExternal;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeFieldName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeIterator;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeTableName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Priority;
import java.util.Iterator;
import java.util.Locale;

public abstract class Node {
    private int startOffset = -1;
    private int endOffset = -1;
    private final NodeType nodeType;
    private boolean hasParentheses;

    protected Node(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public boolean isHasParantheses() {
        return this.hasParentheses;
    }

    public void setHasParantheses(boolean hasParantheses) {
        this.hasParentheses = hasParantheses;
    }

    protected void appendChildren(StringBuffer b, String sep) {
        int length = b.length();
        int count = this.getCount();
        for (int i = 0; i < count; ++i) {
            Node node = this.getItem(i);
            if (node == null) continue;
            if (b.length() != length) {
                b.append(sep);
            }
            if (node.getPriority().isGreaterThanOrEqualTo(this.getPriority()) || node.hasParentheses) {
                b.append("(");
                node.appendTo(b);
                b.append(")");
                continue;
            }
            node.appendTo(b);
        }
    }

    public abstract void appendTo(StringBuffer var1);

    public void bind(IExternal e, NodeTableName tableContext, NodeFieldName fieldContext) {
        if (e != null) {
            e.verifyNode(this, tableContext, fieldContext);
        }
    }

    protected void bindChildren(IExternal e, NodeTableName tableContext, NodeFieldName fieldContext) {
        int childCount = this.getCount();
        for (int childIx = 0; childIx < childCount; ++childIx) {
            this.getItem(childIx).bind(e, tableContext, fieldContext);
        }
    }

    public boolean canCastTo(DataType dataType, Locale locale) {
        return this.getDataType() == dataType;
    }

    public String checkPrefix(String prefix) {
        int count = this.getCount();
        for (int i = 0; i < count; ++i) {
            prefix = this.getItem(i).checkPrefix(prefix);
        }
        return prefix;
    }

    protected boolean isChildrenCanCastTo(DataType dataType, Locale locale) {
        int childCount = this.getCount();
        for (int childIx = 0; childIx < childCount; ++childIx) {
            if (this.getItem(childIx).canCastTo(dataType, locale)) continue;
            return false;
        }
        return true;
    }

    protected DataType getChildrenDataType() {
        int childCount = this.getCount();
        if (childCount == 0) {
            return DataType.VOID;
        }
        DataType childrenDataType = this.getItem(0).getDataType();
        for (int childIx = 1; childIx < childCount; ++childIx) {
            if (this.getItem(childIx).getDataType() == childrenDataType) continue;
            return DataType.UNKNOWN;
        }
        return childrenDataType;
    }

    protected boolean isChildrenConst() {
        int childCount = this.getCount();
        for (int childIx = 0; childIx < childCount; ++childIx) {
            if (this.getItem(childIx).isConst()) continue;
            return false;
        }
        return true;
    }

    public Iterator<Node> iterator() {
        return new NodeIterator(this);
    }

    public Node optimize(IExternal e, NodeTableName tableContext, NodeFieldName fieldContext) {
        if (e == null) {
            return this;
        }
        return e.optimizeNode(this, tableContext, fieldContext);
    }

    protected void optimizeChildren(IExternal e, NodeTableName tableContext, NodeFieldName fieldContext) {
        int childCount = this.getCount();
        for (int childIx = 0; childIx < childCount; ++childIx) {
            this.setItem(childIx, this.getItem(childIx).optimize(e, tableContext, fieldContext));
        }
    }

    public void setPrefix(String prefix) {
        int count = this.getCount();
        for (int i = 0; i < count; ++i) {
            this.getItem(i).setPrefix(prefix);
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        this.appendTo(b);
        return b.toString();
    }

    public String getConstStringValue() {
        return null;
    }

    public abstract int getCount();

    public abstract DataType getDataType();

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    public abstract boolean isConst();

    public abstract boolean isScalar();

    public abstract Node getItem(int var1);

    public abstract void setItem(int var1, Node var2);

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public abstract Priority getPriority();

    public int getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
    }
}

