/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.wiqlparse;

import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Node;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeBoolValue;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeItem;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeNumber;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeOperation;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeSelect;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeString;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeVariable;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Scanner;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.SyntaxError;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.SyntaxException;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Tools;
import java.util.ArrayList;
import java.util.List;

public class Parser {
    public static NodeSelect parseSyntax(String input) {
        List<Node> lexems = Parser.parseLexems(input);
        Scanner scanner = new Scanner(lexems);
        NodeSelect selectNode = scanner.scan();
        scanner.checkTail();
        return selectNode;
    }

    public static List<Node> parseLexems(String input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        ArrayList<Node> lexems = new ArrayList<Node>();
        int length = input.length();
        int currentPos = 0;
        while (currentPos < length) {
            if (Character.isWhitespace(input.charAt(currentPos))) {
                ++currentPos;
                continue;
            }
            if (Character.isLetter(input.charAt(currentPos)) || input.charAt(currentPos) == '_') {
                String val;
                Boolean flag;
                int startIndex = currentPos;
                while (currentPos < length && (Character.isLetterOrDigit(input.charAt(currentPos)) || input.charAt(currentPos) == '_' || input.charAt(currentPos) == '.')) {
                    ++currentPos;
                }
                if (input.charAt(currentPos - 1) == '.') {
                    --currentPos;
                }
                NodeItem node = (flag = Tools.TranslateBoolToken(val = input.substring(startIndex, currentPos))) != null ? new NodeBoolValue(flag) : new NodeName(val);
                node.setStartOffset(startIndex);
                node.setEndOffset(currentPos);
                lexems.add(node);
                continue;
            }
            if (input.charAt(currentPos) == '@') {
                int startIx = ++currentPos;
                while (currentPos < length && Character.isLetterOrDigit(input.charAt(currentPos))) {
                    ++currentPos;
                }
                NodeVariable node = new NodeVariable(input.substring(startIx, currentPos));
                node.setStartOffset(startIx - 1);
                node.setEndOffset(currentPos);
                lexems.add(node);
                continue;
            }
            if (input.charAt(currentPos) == '[') {
                int num5 = ++currentPos;
                int num6 = length;
                boolean flag2 = true;
                while (currentPos < length) {
                    if (input.charAt(currentPos) == ']') {
                        num6 = currentPos++;
                        flag2 = false;
                        break;
                    }
                    ++currentPos;
                }
                NodeName name = new NodeName(input.substring(num5, num6));
                name.setStartOffset(num5 - 1);
                name.setEndOffset(num6 + 1);
                if (flag2) {
                    throw new SyntaxException(name, SyntaxError.EXPECTING_CLOSING_SQUARE_BRACKET);
                }
                if (num5 == num6) {
                    throw new SyntaxException(name, SyntaxError.EMPTY_NAME);
                }
                lexems.add(name);
                continue;
            }
            if ((input.charAt(currentPos) == '-' || input.charAt(currentPos) == '+') && currentPos + 1 < length && Character.isDigit(input.charAt(currentPos + 1)) || Character.isDigit(input.charAt(currentPos))) {
                int startIx = currentPos;
                if (input.charAt(currentPos) == '-' || input.charAt(currentPos) == '+') {
                    ++currentPos;
                }
                while (currentPos < length && Character.isDigit(input.charAt(currentPos))) {
                    ++currentPos;
                }
                if (currentPos < length && input.charAt(currentPos) == '.') {
                    ++currentPos;
                    while (currentPos < length && Character.isDigit(input.charAt(currentPos))) {
                        ++currentPos;
                    }
                }
                if (currentPos < length && (input.charAt(currentPos) == 'e' || input.charAt(currentPos) == 'E')) {
                    if (++currentPos < length && (input.charAt(currentPos) == '-' || input.charAt(currentPos) == '+')) {
                        ++currentPos;
                    }
                    while (currentPos < length && Character.isDigit(input.charAt(currentPos))) {
                        ++currentPos;
                    }
                }
                NodeNumber node = new NodeNumber(input.substring(startIx, currentPos));
                node.setStartOffset(startIx);
                node.setEndOffset(currentPos);
                lexems.add(node);
                continue;
            }
            if (input.charAt(currentPos) == '\'' || input.charAt(currentPos) == '\"') {
                char quoteCharacter = input.charAt(currentPos++);
                int startIx = currentPos;
                int endIx = length;
                boolean didNotFindClosingQuoteCharacter = true;
                while (currentPos < length) {
                    if (input.charAt(currentPos) == quoteCharacter && (++currentPos == length || input.charAt(currentPos) != quoteCharacter)) {
                        endIx = currentPos - 1;
                        didNotFindClosingQuoteCharacter = false;
                        break;
                    }
                    ++currentPos;
                }
                String stringValue = input.substring(startIx, endIx);
                stringValue = stringValue.replaceAll("\\" + quoteCharacter + "\\" + quoteCharacter, String.valueOf(quoteCharacter));
                NodeString node = new NodeString(stringValue);
                node.setStartOffset(startIx - 1);
                node.setEndOffset(endIx + 1);
                if (didNotFindClosingQuoteCharacter) {
                    throw new SyntaxException(node, SyntaxError.EXPECTING_CLOSING_QUOTE);
                }
                lexems.add(node);
                continue;
            }
            if (currentPos + 1 < length && (input.charAt(currentPos) == '<' && input.charAt(currentPos + 1) == '=' || input.charAt(currentPos + 1) == '>' || input.charAt(currentPos) == '>' && input.charAt(currentPos + 1) == '=' || input.charAt(currentPos) == '!' && input.charAt(currentPos + 1) == '=' || input.charAt(currentPos) == '=' && (input.charAt(currentPos + 1) == '=' || input.charAt(currentPos + 1) == '<' || input.charAt(currentPos + 1) == '>') || input.charAt(currentPos) == '&' && input.charAt(currentPos + 1) == '&' || input.charAt(currentPos) == '|' && input.charAt(currentPos + 1) == '|')) {
                NodeOperation node = new NodeOperation(input.substring(currentPos, currentPos + 2));
                node.setStartOffset(currentPos);
                node.setEndOffset(currentPos + 2);
                lexems.add(node);
                currentPos += 2;
                continue;
            }
            NodeOperation node = new NodeOperation(input.substring(currentPos, currentPos + 1));
            node.setStartOffset(currentPos);
            node.setEndOffset(currentPos + 1);
            lexems.add(node);
            ++currentPos;
        }
        return lexems;
    }
}

