/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.query;

import com.microsoft.tfs.core.clients.workitem.query.StoredQuery;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryFolder;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryItem;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryUtils {
    private static final Log log = LogFactory.getLog(QueryUtils.class);

    public static String getExtendedDescription(StoredQuery query) {
        String hierarchy;
        String name;
        QueryItem queryItem = query.getProject().getQueryHierarchy().find(query.getQueryGUID());
        if (queryItem == null) {
            log.warn((Object)MessageFormat.format("Could not locate query {0} in query hierarchy", query.getQueryGUID()));
            name = query.getName();
            hierarchy = query.getProject().getName();
        } else {
            name = queryItem.getName();
            QueryFolder parent = queryItem.getParent();
            if (parent == null) {
                return name;
            }
            hierarchy = parent.getName();
            while (parent.getParent() != null) {
                hierarchy = MessageFormat.format("{0} / {1}", parent.getParent().getName(), hierarchy);
                parent = parent.getParent();
            }
        }
        return MessageFormat.format("{0} ({1})", name, hierarchy);
    }
}

