/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.credentials.internal;

import com.microsoft.tfs.core.credentials.CachedCredentials;
import com.microsoft.tfs.core.credentials.internal.PersistenceStoreCredentialsManager;
import com.microsoft.tfs.core.internal.persistence.DOMObjectSerializer;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.util.xml.DOMCreateUtils;
import com.microsoft.tfs.util.xml.DOMUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CachedCredentialsSerializer
extends DOMObjectSerializer {
    private static final Log log = LogFactory.getLog(CachedCredentialsSerializer.class);
    private static final int SCHEMA_VERSION = 1;
    private static final String CREDENTIALS_CACHE_ELEMENT_NAME = "credentials";
    private static final String VERSION_ATTRIBUTE_NAME = "version";
    private static final String CREDENTIALS_ELEMENT_NAME = "credentials";
    private static final String URI_ATTRIBUTE_NAME = "uri";
    private static final String USERNAME_ELEMENT_NAME = "username";
    private static final String PASSWORD_ELEMENT_NAME = "password";

    @Override
    protected Document createDocumentFromComponent(Object object) {
        Map credentialsMap = (Map)object;
        Document document = DOMCreateUtils.newDocument("credentials");
        Element rootElement = document.getDocumentElement();
        rootElement.setAttribute(VERSION_ATTRIBUTE_NAME, String.valueOf(1));
        for (CachedCredentials credentials : credentialsMap.values()) {
            this.serializeCredentials(credentials, document, rootElement);
        }
        return document;
    }

    private void serializeCredentials(CachedCredentials credentials, Document document, Element parentElement) {
        Element credentialsElement = DOMUtils.appendChild(parentElement, "credentials");
        credentialsElement.setAttribute(URI_ATTRIBUTE_NAME, URIUtils.removeTrailingSlash(credentials.getURI()).toString());
        if (credentials.getUsername() != null) {
            DOMUtils.appendChildWithText(credentialsElement, USERNAME_ELEMENT_NAME, this.encodeCredentialField(credentials.getUsername()));
        }
        if (credentials.getPassword() != null) {
            DOMUtils.appendChildWithText(credentialsElement, PASSWORD_ELEMENT_NAME, this.encodeCredentialField(credentials.getPassword()));
        }
    }

    @Override
    protected Object createComponentFromDocument(Document document) {
        Element root = document.getDocumentElement();
        if (!"credentials".equals(root.getNodeName())) {
            throw new RuntimeException(MessageFormat.format("Unexpected root element {0}", root.getNodeName()));
        }
        int schemaVersion = -1;
        String sSchemaVersion = root.getAttribute(VERSION_ATTRIBUTE_NAME);
        if (sSchemaVersion != null && sSchemaVersion.length() > 0) {
            try {
                schemaVersion = Integer.parseInt(sSchemaVersion);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        Map<URI, CachedCredentials> credentialsMap = PersistenceStoreCredentialsManager.newMap();
        Element[] credentialsElements = DOMUtils.getChildElements(root, "credentials");
        for (int i = 0; i < credentialsElements.length; ++i) {
            CachedCredentials credentials = this.deserializeCredentials(credentialsElements[i], schemaVersion);
            if (credentials == null) continue;
            credentialsMap.put(credentials.getURI(), credentials);
        }
        return credentialsMap;
    }

    private CachedCredentials deserializeCredentials(Element workspaceElement, int schemaVersion) {
        Element passwordElement;
        URI uri;
        String uriSerialized = workspaceElement.getAttribute(URI_ATTRIBUTE_NAME);
        if (uriSerialized == null || uriSerialized.length() == 0) {
            return null;
        }
        String username = null;
        String password = null;
        try {
            uri = new URI(uriSerialized);
        }
        catch (Exception e) {
            log.warn((Object)"Could not deserialize credentials data", (Throwable)e);
            return null;
        }
        Element usernameElement = DOMUtils.getFirstChildElement(workspaceElement, USERNAME_ELEMENT_NAME);
        if (usernameElement != null && (username = DOMUtils.getText(usernameElement)) != null && (username = this.decodeCredentialField(username).trim()).length() == 0) {
            username = null;
        }
        if ((passwordElement = DOMUtils.getFirstChildElement(workspaceElement, PASSWORD_ELEMENT_NAME)) != null && (password = DOMUtils.getText(passwordElement)) != null && (password = this.decodeCredentialField(password)).length() == 0) {
            password = null;
        }
        return new CachedCredentials(uri, username, password);
    }

    private String encodeCredentialField(String field) {
        try {
            return URLEncoder.encode(field, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String decodeCredentialField(String field) {
        try {
            return URLDecoder.decode(field, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

