/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.ws.runtime.xml;

import com.microsoft.tfs.core.ws.runtime.types.GUID;
import com.microsoft.tfs.core.ws.runtime.xml.XMLConvert;
import com.microsoft.tfs.util.base64.Base64;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Calendar;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public abstract class XMLStreamWriterHelper {
    public static void writeAttribute(XMLStreamWriter writer, String attributeName, String value) throws XMLStreamException {
        if (value == null) {
            return;
        }
        writer.writeAttribute(attributeName, value);
    }

    public static void writeAttribute(XMLStreamWriter writer, String attributeName, Calendar value, boolean includeTime) throws XMLStreamException {
        if (value == null) {
            return;
        }
        writer.writeAttribute(attributeName, XMLConvert.toString(value, includeTime));
    }

    public static void writeAttribute(XMLStreamWriter writer, String attributeName, short value) throws XMLStreamException {
        writer.writeAttribute(attributeName, XMLConvert.toString(value));
    }

    public static void writeAttribute(XMLStreamWriter writer, String attributeName, int value) throws XMLStreamException {
        writer.writeAttribute(attributeName, XMLConvert.toString(value));
    }

    public static void writeAttribute(XMLStreamWriter writer, String attributeName, long value) throws XMLStreamException {
        writer.writeAttribute(attributeName, XMLConvert.toString(value));
    }

    public static void writeAttribute(XMLStreamWriter writer, String attributeName, float value) throws XMLStreamException {
        writer.writeAttribute(attributeName, XMLConvert.toString(value));
    }

    public static void writeAttribute(XMLStreamWriter writer, String attributeName, byte[] value) throws XMLStreamException {
        if (value == null) {
            return;
        }
        try {
            writer.writeAttribute(attributeName, new String(Base64.encodeBase64(value), "US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeAttribute(XMLStreamWriter writer, String attributeName, String[] value) throws XMLStreamException {
        if (value == null || value.length == 0) {
            return;
        }
        for (int i = 0; i < value.length; ++i) {
            writer.writeAttribute(attributeName, value[i]);
        }
    }

    public static void writeAttribute(XMLStreamWriter writer, String attributeName, boolean value) throws XMLStreamException {
        writer.writeAttribute(attributeName, XMLConvert.toString(value));
    }

    public static void writeElement(XMLStreamWriter writer, String elementName, String value) throws XMLStreamException {
        if (value == null) {
            return;
        }
        writer.writeStartElement(elementName);
        writer.writeCharacters(value);
        writer.writeEndElement();
    }

    public static void writeElement(XMLStreamWriter writer, String elementName, Calendar value, boolean includeTime) throws XMLStreamException {
        if (value == null) {
            return;
        }
        writer.writeStartElement(elementName);
        writer.writeCharacters(XMLConvert.toString(value, includeTime));
        writer.writeEndElement();
    }

    public static void writeElement(XMLStreamWriter writer, String elementName, int value) throws XMLStreamException {
        writer.writeStartElement(elementName);
        writer.writeCharacters(XMLConvert.toString(value));
        writer.writeEndElement();
    }

    public static void writeElement(XMLStreamWriter writer, String elementName, long value) throws XMLStreamException {
        writer.writeStartElement(elementName);
        writer.writeCharacters(XMLConvert.toString(value));
        writer.writeEndElement();
    }

    public static void writeElement(XMLStreamWriter writer, String elementName, String[] value) throws XMLStreamException {
        if (value == null || value.length == 0) {
            return;
        }
        writer.writeStartElement(elementName);
        for (int i = 0; i < value.length; ++i) {
            writer.writeStartElement("string");
            writer.writeCharacters(value[i]);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public static void writeElement(XMLStreamWriter writer, String elementName, byte[] value) throws XMLStreamException {
        if (value == null) {
            return;
        }
        writer.writeStartElement(elementName);
        try {
            writer.writeCharacters(new String(Base64.encodeBase64(value), "US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        writer.writeEndElement();
    }

    public static void writeElement(XMLStreamWriter writer, String elementName, boolean value) throws XMLStreamException {
        writer.writeStartElement(elementName);
        writer.writeCharacters(XMLConvert.toString(value));
        writer.writeEndElement();
    }

    public static void writeElement(XMLStreamWriter writer, String elementName, Object value) throws XMLStreamException {
        if (value == null) {
            writer.writeStartElement(elementName);
            writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
            writer.writeEndElement();
        } else {
            String namespace;
            String stringValue;
            String localName;
            if (value instanceof Boolean) {
                localName = "boolean";
                stringValue = XMLConvert.toString((Boolean)value);
                namespace = "http://www.w3.org/2001/XMLSchema";
            } else if (value instanceof Byte) {
                localName = "unsignedByte";
                stringValue = XMLConvert.toString(((Byte)value).shortValue());
                namespace = "http://www.w3.org/2001/XMLSchema";
            } else if (value instanceof Character) {
                localName = "char";
                stringValue = XMLConvert.toString(((Character)value).charValue());
                namespace = "http://microsoft.com/wsdl/types/";
            } else if (value instanceof Short) {
                localName = "short";
                stringValue = XMLConvert.toString((Short)value);
                namespace = "http://www.w3.org/2001/XMLSchema";
            } else if (value instanceof Integer) {
                localName = "int";
                stringValue = XMLConvert.toString((Integer)value);
                namespace = "http://www.w3.org/2001/XMLSchema";
            } else if (value instanceof Long) {
                localName = "long";
                stringValue = XMLConvert.toString((Long)value);
                namespace = "http://www.w3.org/2001/XMLSchema";
            } else if (value instanceof Float) {
                localName = "float";
                stringValue = XMLConvert.toString(((Float)value).floatValue());
                namespace = "http://www.w3.org/2001/XMLSchema";
            } else if (value instanceof Double) {
                localName = "double";
                stringValue = XMLConvert.toString((Double)value);
                namespace = "http://www.w3.org/2001/XMLSchema";
            } else if (value instanceof Float) {
                localName = "float";
                stringValue = XMLConvert.toString(((Float)value).floatValue());
                namespace = "http://www.w3.org/2001/XMLSchema";
            } else if (value instanceof String) {
                localName = "string";
                stringValue = (String)value;
                namespace = "http://www.w3.org/2001/XMLSchema";
            } else if (value instanceof Calendar) {
                localName = "dateTime";
                stringValue = XMLConvert.toString((Calendar)value, true);
                namespace = "http://www.w3.org/2001/XMLSchema";
            } else if (value instanceof BigDecimal) {
                localName = "decimal";
                stringValue = XMLConvert.toString((BigDecimal)value);
                namespace = "http://www.w3.org/2001/XMLSchema";
            } else if (value instanceof GUID) {
                localName = "guid";
                stringValue = XMLConvert.toString((GUID)value);
                namespace = "http://microsoft.com/wsdl/types/";
            } else if (value instanceof byte[]) {
                localName = "base64Binary";
                try {
                    stringValue = new String(Base64.encodeBase64((byte[])value), "US-ASCII");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                namespace = "http://www.w3.org/2001/XMLSchema";
            } else {
                if (value.getClass().isArray()) {
                    writer.writeStartElement(elementName);
                    writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "ArrayOfAnyType");
                    XMLStreamWriterHelper.writeObjectArray(writer, null, (Object[])value);
                    writer.writeEndElement();
                }
                return;
            }
            writer.writeStartElement(elementName);
            writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", writer.getNamespaceContext().getPrefix(namespace) + ":" + localName);
            writer.writeCharacters(stringValue);
            writer.writeEndElement();
        }
    }

    private static void writeObjectArray(XMLStreamWriter writer, String elementName, Object[] value) throws XMLStreamException {
        if (value != null && value.length != 0) {
            if (elementName != null && elementName.length() > 0) {
                writer.writeStartElement(elementName);
            }
            for (int i = 0; i < value.length; ++i) {
                if (value[i] == null) {
                    throw new IllegalArgumentException("value[" + i + "]");
                }
                XMLStreamWriterHelper.writeElement(writer, "anyType", value[i]);
            }
            if (elementName != null && elementName.length() > 0) {
                writer.writeEndElement();
            }
        }
    }

    public static String escapeNewlinesForXMLAttribute(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (c == '\r') {
                sb.append("&#xD;");
                continue;
            }
            if (c == '\n') {
                sb.append("&#xA;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

