/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.appleforked.fileformat;

import com.microsoft.tfs.util.ByteArrayUtils;
import com.microsoft.tfs.util.Check;

public class AppleForkedEntryDescriptor {
    public static final int ENTRY_DESCRIPTOR_SIZE = 12;
    private long type;
    private long offset;
    private long length;

    public AppleForkedEntryDescriptor() {
    }

    public AppleForkedEntryDescriptor(long type, long offset, long length) {
        this.setType(type);
        this.setOffset(offset);
        this.setLength(length);
    }

    public AppleForkedEntryDescriptor(byte[] buffer) {
        this.decode(buffer);
    }

    public long getType() {
        return this.type;
    }

    public void setType(long type) {
        Check.isTrue(type >= 0L, "type >= 0");
        this.type = type;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        Check.isTrue(offset >= 0L, "offset >= 0");
        this.offset = offset;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        Check.isTrue(length >= 0L, "length >= 0");
        this.length = length;
    }

    public byte[] encode() {
        byte[] descriptor = new byte[12];
        ByteArrayUtils.putUnsignedInt32(descriptor, 0, this.type);
        ByteArrayUtils.putUnsignedInt32(descriptor, 4, this.offset);
        ByteArrayUtils.putUnsignedInt32(descriptor, 8, this.length);
        return descriptor;
    }

    public void decode(byte[] descriptor) {
        Check.notNull(descriptor, "descriptor");
        Check.isTrue(descriptor.length == 12, "descriptor.length == ENTRY_DESCRIPTOR_SIZE");
        this.type = ByteArrayUtils.getUnsignedInt32(descriptor, 0);
        this.offset = ByteArrayUtils.getUnsignedInt32(descriptor, 4);
        this.length = ByteArrayUtils.getUnsignedInt32(descriptor, 8);
    }

    public String toString() {
        StringBuffer value = new StringBuffer();
        value.append("type=" + this.type + ", ");
        value.append("offset=" + this.offset + ", ");
        value.append("length=" + this.length);
        return value.toString();
    }
}

