/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.reportparser.parser.clover;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.xml.OfflineSaxHandlerBase;
import org.xml.sax.Attributes;

public class CloverReportHandler
extends OfflineSaxHandlerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FILE_ELEMENT = "file";
    private static final String LINE_ELEMENT = "line";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String PATH_ATTRIBUTE = "path";
    private static final String LINE_NUMBER_ATTRIBUTE = "num";
    private static final String COUNT_ATTRIBUTE = "count";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String CONDITIONAL_TYPE = "cond";
    private static final String METHOD_TYPE = "method";
    private static final String STATEMENT_TYPE = "stmt";
    private final CoverageInfoRetriever lineCoverageInfoRetriever;
    private LineCoverageInfo currentLineCoverage;

    public CloverReportHandler(CoverageInfoRetriever lineCoverageInfoRetriever) {
        CCSMAssert.isNotNull((Object)lineCoverageInfoRetriever);
        this.lineCoverageInfoRetriever = lineCoverageInfoRetriever;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        switch (qName) {
            case "file": {
                String fileName = attributes.getValue(PATH_ATTRIBUTE);
                if (fileName == null) {
                    fileName = attributes.getValue(NAME_ATTRIBUTE);
                }
                this.currentLineCoverage = this.lineCoverageInfoRetriever.getOrCreateLineCoverageInfo(fileName);
                break;
            }
            case "line": {
                this.parseLineElement(attributes);
                break;
            }
        }
    }

    private void parseLineElement(Attributes attributes) {
        String type;
        int lineNumber = Integer.parseInt(attributes.getValue(LINE_NUMBER_ATTRIBUTE));
        switch (type = attributes.getValue(TYPE_ATTRIBUTE)) {
            case "cond": {
                break;
            }
            case "method": 
            case "stmt": {
                this.currentLineCoverage.addLineCoverage(lineNumber, CloverReportHandler.parseCoverage(attributes));
                break;
            }
            default: {
                LOGGER.error("Found unknown line element type in Clover report: {}", (Object)type);
            }
        }
    }

    private static ELineCoverage parseCoverage(Attributes attributes) {
        if (Long.parseLong(attributes.getValue(COUNT_ATTRIBUTE)) > 0L) {
            return ELineCoverage.FULLY_COVERED;
        }
        return ELineCoverage.NOT_COVERED;
    }
}

