/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.function;

import java.util.function.Function;
import org.conqat.lib.commons.function.MemoizingSupplierWithException;

@FunctionalInterface
public interface SupplierWithException<T, E extends Exception> {
    public T get() throws E;

    default public <E_NEW extends Exception> SupplierWithException<T, E_NEW> withOtherException(Function<Exception, E_NEW> exceptionMapper) {
        return () -> {
            try {
                return this.get();
            }
            catch (Exception e) {
                throw (Exception)exceptionMapper.apply(e);
            }
        };
    }

    public static <T, E extends Exception> SupplierWithException<T, E> memoize(SupplierWithException<T, E> delegate) {
        if (delegate instanceof MemoizingSupplierWithException) {
            return delegate;
        }
        return new MemoizingSupplierWithException<T, E>(delegate);
    }
}

