/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.string;

import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CompactLines;
import org.conqat.lib.commons.string.LineRange;

public class LineRangeStringParser {
    private int currentLine = 0;
    private int startLine = 0;
    private boolean isParsingEndLine = false;

    public CompactLines parse(String lineNumbersString) {
        this.reset();
        CompactLines lineNumbers = new CompactLines();
        for (int characterIndex = 0; characterIndex < lineNumbersString.length(); ++characterIndex) {
            char currentChar = lineNumbersString.charAt(characterIndex);
            if (Character.isDigit(currentChar)) {
                this.currentLine = this.currentLine * 10 + Character.digit(currentChar, 10);
                continue;
            }
            if (currentChar == '-') {
                if (this.isParsingEndLine) {
                    CCSMAssert.fail("Line number pattern at character " + characterIndex + " is invalid in: " + lineNumbersString);
                }
                this.startLine = this.currentLine;
                this.currentLine = 0;
                this.isParsingEndLine = true;
                continue;
            }
            if (currentChar == ',') {
                this.appendLines(lineNumbers);
                this.reset();
                continue;
            }
            if (Character.isWhitespace(currentChar)) continue;
            CCSMAssert.fail("Unexpected character " + currentChar + " in " + lineNumbersString);
        }
        this.appendLines(lineNumbers);
        return lineNumbers;
    }

    public static List<LineRange> compactifyToRanges(CompactLines lines) {
        if (lines.isEmpty()) {
            return new ArrayList<LineRange>();
        }
        int firstLine = lines.iterator().next();
        LineRange currentRange = new LineRange(firstLine, firstLine);
        ArrayList<LineRange> compactifiedRanges = new ArrayList<LineRange>();
        compactifiedRanges.add(currentRange);
        for (int currentLine : lines) {
            if (currentRange.getEnd() == currentLine || currentRange.getEnd() == currentLine - 1) {
                currentRange.setEnd(currentLine);
                continue;
            }
            currentRange = new LineRange(currentLine, currentLine);
            compactifiedRanges.add(currentRange);
        }
        return compactifiedRanges;
    }

    private void appendLines(CompactLines lineNumbers) {
        if (this.currentLine == 0) {
            return;
        }
        if (this.isParsingEndLine) {
            lineNumbers.addRange(this.startLine, this.currentLine);
        } else {
            lineNumbers.add(this.currentLine);
        }
    }

    private void reset() {
        this.currentLine = 0;
        this.startLine = 0;
        this.isParsingEndLine = false;
    }
}

