/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.string;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class SimpleNLPUtils {
    private static final Pattern WORD_SEPARATION_PATTERN = Pattern.compile("[\\s\\p{Z}]+");
    public static final List<String> IRREGULAR_SUPERLATIVES = Arrays.asList("best", "worst", "least", "furthest", "farthest");
    public static final List<String> IRREGULAR_COMPARATIVES = Arrays.asList("better", "worse", "less", "further", "farther");
    public static final String REGEX_WORD_WITH_TWO_SYLLABLES = "\\b\\w*?([aeiouy]+[^aeiouy\\s]+){2,}\\w*?\\b";
    private static final Pattern SENTENCE_END_PATTERN = Pattern.compile("\\s*(\\S.*?[.!?])(?=\\s+\\p{Lu}|$)", 32);

    public static @NonNull List<String> splitIntoWords(@Nullable String text) {
        if (StringUtils.isEmpty(text)) {
            return CollectionUtils.emptyList();
        }
        return Arrays.stream(WORD_SEPARATION_PATTERN.split(text)).filter(word -> !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)word)).collect(Collectors.toList());
    }

    public static @NonNull String removeIgnoredSubstrings(@NonNull Pattern ignorePattern, @Nullable String text) {
        if (text == null) {
            return "";
        }
        Matcher matcher = ignorePattern.matcher(text);
        StringBuilder builder = new StringBuilder(text);
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            builder.replace(startIndex, endIndex, " ".repeat(endIndex - startIndex));
        }
        return builder.toString();
    }

    private static boolean isWordBoundary(char character) {
        return !Character.isLetterOrDigit(character);
    }

    public static boolean hasWordBoundaries(int index, int wordLength, String text) {
        if (index > 0 && !SimpleNLPUtils.isWordBoundary(text.charAt(index - 1))) {
            return false;
        }
        return index + wordLength >= text.length() || SimpleNLPUtils.isWordBoundary(text.charAt(index + wordLength));
    }

    public static List<SentenceDetails> splitIntoSentences(String text) {
        if (StringUtils.isEmpty(text)) {
            return CollectionUtils.emptyList();
        }
        ArrayList<SentenceDetails> sentences = new ArrayList<SentenceDetails>();
        Matcher matcher = SENTENCE_END_PATTERN.matcher(text);
        while (matcher.find()) {
            String sentence = matcher.group(1);
            int start = matcher.start(1);
            int end = matcher.end(1);
            sentences.add(new SentenceDetails(sentence, start, end - 1));
        }
        return sentences;
    }

    private SimpleNLPUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    public static class SentenceDetails {
        private final String sentence;
        private final int startOffset;
        private final int endOffset;

        public SentenceDetails(String sentence, int startOffset, int endOffset) {
            this.sentence = sentence;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public String getSentence() {
            return this.sentence;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }
}

