/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.cache;

import org.conqat.engine.persistence.cache.StorageCacheBase;
import org.conqat.engine.persistence.cache.StorageCacheProvider;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.FunctionWithException;

public class SynchronizedCacheAccess<CACHE extends StorageCacheBase> {
    private final IMessageBroker messageBroker;
    private final String storageSystemName;
    private final CACHE indexCache;

    public SynchronizedCacheAccess(CACHE indexCache, String storageSystemName, IMessageBroker messageBroker) {
        this.indexCache = indexCache;
        this.storageSystemName = storageSystemName;
        this.messageBroker = messageBroker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <VALUE> VALUE getOrUpdate(FunctionWithException<CACHE, VALUE, StorageException> cacheAccess) throws StorageException {
        CACHE CACHE = this.indexCache;
        synchronized (CACHE) {
            return (VALUE)cacheAccess.apply(this.indexCache);
        }
    }

    public void invalidate(String reason) {
        ((StorageCacheBase)this.indexCache).invalidateThreadSafe();
        this.messageBroker.sendMessage(StorageCacheProvider.buildMessageChannelId(this.storageSystemName, this.indexCache.getClass()), reason);
    }
}

