/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IChangeTrackingIndex;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.IStorageKeyTranslatingIndex;
import org.conqat.engine.persistence.index.IStringKeyIndex;
import org.conqat.engine.persistence.index.IUtilityIndex;
import org.conqat.engine.persistence.index.SimpleCrudIndex;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.function.RunnableWithException;
import org.conqat.lib.commons.function.SupplierWithException;
import org.jetbrains.annotations.VisibleForTesting;

public final class LastChangeTrackingValueIndex<T extends Serializable>
implements IChangeTrackingIndex,
IStringKeyIndex<T>,
IUtilityIndex,
IStorageKeyTranslatingIndex {
    private final ValueIndex<T> valueDelegate;
    private final SimpleCrudIndex<SimpleCrudIndex.ESingletonKey, Long> lastChangeTimestampDelegate;

    public LastChangeTrackingValueIndex(IStore store) {
        this.valueDelegate = ValueIndex.forSerializable(new DelegatingPartitionStore(store, "values"));
        this.lastChangeTimestampDelegate = SimpleCrudIndex.forSingleKey(new DelegatingPartitionStore(store, "last-change-timestamp"), ISerializer.forLong());
    }

    private void updateLastChangedTimestamp() throws StorageException {
        this.setLastChangeTimestamp(System.currentTimeMillis());
    }

    @Override
    public void setValue(@NonNull String key, @NonNull T value) throws StorageException {
        this.valueDelegate.setValue(key, value);
        this.updateLastChangedTimestamp();
    }

    @Override
    public void setValues(PairList<String, T> values) throws StorageException {
        this.valueDelegate.setValues(values);
        this.updateLastChangedTimestamp();
    }

    @Override
    public void setOrMergeValues(PairList<@NonNull String, @NonNull T> keysAndValues, BinaryOperator<T> mergeFunction) throws StorageException {
        this.valueDelegate.setOrMergeValues(keysAndValues, mergeFunction);
        this.updateLastChangedTimestamp();
    }

    @Override
    public void setOrMergeValue(@NonNull String key, @NonNull T value, BinaryOperator<T> mergeFunction) throws StorageException {
        this.valueDelegate.setOrMergeValue(key, value, mergeFunction);
        this.updateLastChangedTimestamp();
    }

    @Override
    public void removeValue(@NonNull String key) throws StorageException {
        this.valueDelegate.removeValue(key);
        this.updateLastChangedTimestamp();
    }

    @Override
    public void removeValues(Collection<String> keys) throws StorageException {
        this.valueDelegate.removeValues(keys);
        this.updateLastChangedTimestamp();
    }

    @Override
    public OptionalLong getLastChangeTimestamp() throws StorageException {
        return this.lastChangeTimestampDelegate.get(SimpleCrudIndex.ESingletonKey.INSTANCE).map(OptionalLong::of).orElseGet(OptionalLong::empty);
    }

    @VisibleForTesting
    public void setLastChangeTimestamp(long timestamp) throws StorageException {
        this.lastChangeTimestampDelegate.put(SimpleCrudIndex.ESingletonKey.INSTANCE, timestamp);
    }

    @Override
    public @Nullable T getValue(@NonNull String key) throws StorageException {
        return (T)((Serializable)this.valueDelegate.getValue(key));
    }

    @Override
    public T getValue(@NonNull String key, boolean forceExistence) throws StorageException {
        return (T)((Serializable)this.valueDelegate.getValue(key, forceExistence));
    }

    @Override
    public List<@Nullable T> getValues(List<@NonNull String> keys) throws StorageException {
        return this.valueDelegate.getValues(keys);
    }

    @Override
    public List<T> getValues(List<@NonNull String> keys, boolean forceExistence) throws StorageException {
        return this.valueDelegate.getValues(keys, forceExistence);
    }

    @Override
    public List<String> getAllKeys() throws StorageException {
        return this.valueDelegate.getAllKeys();
    }

    @Override
    public List<String> getKeysStartingWith(@NonNull String prefix) throws StorageException {
        return this.valueDelegate.getKeysStartingWith(prefix);
    }

    @Override
    public PairList<String, T> getAllEntries() throws StorageException {
        return this.valueDelegate.getAllEntries();
    }

    @Override
    public PairList<String, T> getEntriesStartingWith(@NonNull String prefix) throws StorageException {
        return this.valueDelegate.getEntriesStartingWith(prefix);
    }

    @Override
    public PairList<String, T> getEntriesStartingWith(List<@NonNull String> prefixes) throws StorageException {
        return this.valueDelegate.getEntriesStartingWith(prefixes);
    }

    @Override
    public Set<String> getContainedKeys(List<@NonNull String> keys) throws StorageException {
        return this.valueDelegate.getContainedKeys(keys);
    }

    public <E extends Exception> void runLocked(String suffix, RunnableWithException<E> lockedOperation) throws E {
        this.valueDelegate.runLocked(suffix, lockedOperation);
    }

    public <R, E extends Exception> R computeLocked(String suffix, SupplierWithException<R, E> lockedComputation) throws E {
        return this.valueDelegate.computeLocked(suffix, lockedComputation);
    }

    @Override
    public Set<StorageKey> resolveToPublicKeys(Collection<StorageKey> keys) throws IllegalArgumentException {
        HashSet<StorageKey> result = new HashSet<StorageKey>();
        for (StorageKey key : keys) {
            DelegatingPartitionStore valueStore;
            byte[] rawKey = key.getKey();
            DelegatingPartitionStore delegatingPartitionStore = this.valueDelegate.getWrappedStore(DelegatingPartitionStore.class);
            if (delegatingPartitionStore instanceof DelegatingPartitionStore && (valueStore = delegatingPartitionStore).isFromThisPartition(rawKey)) {
                result.add(new StorageKey(valueStore.getOriginalKey(rawKey)));
                continue;
            }
            if (this.lastChangeTimestampDelegate.getWrappedStore(DelegatingPartitionStore.class).isFromThisPartition(rawKey)) continue;
            throw new IllegalArgumentException("The key '%s' is not associated with this index.".formatted(new Object[]{key}));
        }
        return result;
    }

    @Override
    public IStore getWrappedStore() {
        return this.valueDelegate.getWrappedStore(DelegatingPartitionStore.class).getBaseStore();
    }
}

