/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index;

import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.RandomStringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.UserPseudonymizationSalt;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@Index(name="_meta", options={EStorageOption.NO_ROLLBACK}, valueClasses={IMetaIndexEntry.class})
public class MetaIndex
extends IndexBase
implements IGlobalIndex,
IProjectIndex {
    public static final String NAME = "_meta";
    private static final String USER_PSEUDONYMIZATION_SALT_KEY = "##user-pseudonymization-salt##";
    private static UserPseudonymizationSalt cachedUserPseudonymizationSalt = null;
    private static final String EXTERNAL_LINK_COMMIT_TEMPLATE_INDEX_KEY = "##external-link-commit-template##";
    private static final String EXTERNAL_LINK_COMMIT_IN_MERGE_REQUEST_TEMPLATE_INDEX_KEY = "##external-link-commit-in-merge-request-template##";
    private static final String DEFAULT_BRANCH_NAME_KEY = "##default-branch##";

    public MetaIndex(IStore store) {
        super(store);
    }

    public <T extends IMetaIndexEntry> T getValue(Class<T> clazz) throws StorageException {
        byte[] bytes = this.store.getWithString(clazz.getName());
        if (bytes == null) {
            return null;
        }
        Object value = StorageUtils.deserialize(bytes);
        if (value != null && !clazz.isInstance(value)) {
            throw new StorageException("Storage system returned object of unexpected type: " + String.valueOf(value.getClass()));
        }
        return (T)((IMetaIndexEntry)clazz.cast(value));
    }

    public <T extends IMetaIndexEntry> void setValue(T value, Class<T> explicitClass) throws StorageException {
        if (value != null && !explicitClass.isInstance(value)) {
            throw new IllegalArgumentException("Value is not of expected type %s but %s".formatted(explicitClass, value.getClass()));
        }
        try {
            this.store.putWithString(explicitClass.getName(), SerializationUtils.serializeToByteArray(value));
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public void setStringValue(@NonNull String key, @NonNull String value) throws StorageException {
        this.store.putWithString(key, StringUtils.stringToBytes((String)value));
    }

    public Optional<String> getStringValue(String key) throws StorageException {
        return Optional.ofNullable(StringUtils.bytesToString((byte[])this.store.getWithString(key)));
    }

    public void setLongValue(String key, long value) throws StorageException {
        this.store.putWithString(key, ByteArrayUtils.longToByteArray((long)value));
    }

    public Optional<Long> getLongValue(String key) throws StorageException {
        byte[] value = this.store.getWithString(key);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(ByteArrayUtils.byteArrayToLong((byte[])value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getUserPseudonymizationSalt() throws StorageException {
        if (cachedUserPseudonymizationSalt != null && cachedUserPseudonymizationSalt.isValid()) {
            return MetaIndex.cachedUserPseudonymizationSalt.salt;
        }
        Lock lock = this.store.obtainLock(USER_PSEUDONYMIZATION_SALT_KEY);
        try {
            lock.lock();
            byte[] dateAndSaltBytes = this.store.getWithString(USER_PSEUDONYMIZATION_SALT_KEY);
            if (dateAndSaltBytes == null) {
                String string = this.computeAndStoreUserPseudonymizationSalt();
                return string;
            }
            UserPseudonymizationSalt salt = (UserPseudonymizationSalt)StorageUtils.deserialize(dateAndSaltBytes);
            if (salt.isValid()) {
                cachedUserPseudonymizationSalt = salt;
                String string = salt.salt;
                return string;
            }
            String string = this.computeAndStoreUserPseudonymizationSalt();
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    private synchronized String computeAndStoreUserPseudonymizationSalt() throws StorageException {
        UserPseudonymizationSalt salt = new UserPseudonymizationSalt(LocalDate.now(), RandomStringUtils.randomAlphanumeric((int)32));
        this.store.putWithString(USER_PSEUDONYMIZATION_SALT_KEY, StorageUtils.serialize(salt));
        cachedUserPseudonymizationSalt = salt;
        return salt.salt;
    }

    public synchronized Optional<String> getExternalLinkTemplateForCommit(String connectorIdentifier) throws StorageException {
        return this.getStringValue(MetaIndex.makeExternalLinkTemplateForCommitKey(connectorIdentifier));
    }

    public synchronized Optional<String> getExternalLinkTemplateForCommitInMergeRequest(String connectorIdentifier) throws StorageException {
        return this.getStringValue(MetaIndex.makeExternalLinkTemplateForCommitInMergeRequestKey(connectorIdentifier));
    }

    public void setDefaultBranchName(String defaultBranchName) throws StorageException {
        this.store.putWithString(DEFAULT_BRANCH_NAME_KEY, StringUtils.stringToBytes((String)defaultBranchName));
    }

    public String getDefaultBranchName() throws StorageException {
        return Optional.ofNullable(StringUtils.bytesToString((byte[])this.store.getWithString(DEFAULT_BRANCH_NAME_KEY))).orElseThrow(() -> new StorageException("Default branch not yet set"));
    }

    public void clear() throws StorageException {
        IndexSchema indexSchema = this.getValue(IndexSchema.class);
        StorageUtils.clearStore(this.store);
        this.setValue(indexSchema, IndexSchema.class);
    }

    public static String makeExternalLinkTemplateForCommitKey(String connectorIdentifier) {
        return EXTERNAL_LINK_COMMIT_TEMPLATE_INDEX_KEY + connectorIdentifier;
    }

    public static String makeExternalLinkTemplateForCommitInMergeRequestKey(String connectorIdentifier) {
        return EXTERNAL_LINK_COMMIT_IN_MERGE_REQUEST_TEMPLATE_INDEX_KEY + connectorIdentifier;
    }

    @IndexValueClass
    public static interface IMetaIndexEntry
    extends Serializable {
    }
}

