/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.IStoreCapability;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.ByteArrayWrapper;
import org.conqat.lib.commons.collections.PairList;

public abstract class StoreBase
implements IStore {
    @Override
    public void scan(byte @NonNull [] prefix, IKeyValueCallback callback) throws StorageException {
        CCSMAssert.isNotNull((Object)prefix);
        this.scan(prefix, StoreBase.generateEndKey(prefix), callback);
    }

    @Override
    public void scan(List<byte @NonNull []> prefixes, List<? extends IKeyValueCallback> callbacks) throws StorageException {
        Set keys = Collections.synchronizedSet(new HashSet());
        for (int i = 0; i < prefixes.size(); ++i) {
            byte[] prefix = prefixes.get(i);
            StoreBase.throwIfKeyIsNull(prefix);
            IKeyValueCallback callback = callbacks.get(i);
            this.scan(prefix, (byte[] key, byte[] value) -> {
                if (keys.add(new ByteArrayWrapper(key))) {
                    callback.callback(key, value);
                }
            });
        }
    }

    @Override
    public void scanKeys(byte @NonNull [] prefix, IKeyValueCallback callback) throws StorageException {
        this.scanKeys(prefix, StoreBase.generateEndKey(prefix), callback);
    }

    @Override
    public void scanKeys(List<byte @NonNull []> prefixes, List<? extends IKeyValueCallback> callbacks) throws StorageException {
        Set keys = Collections.synchronizedSet(new HashSet());
        for (int i = 0; i < prefixes.size(); ++i) {
            byte[] prefix = prefixes.get(i);
            IKeyValueCallback callback = callbacks.get(i);
            this.scanKeys(prefix, (byte[] key, byte[] value) -> {
                if (keys.add(new ByteArrayWrapper(key))) {
                    callback.callback(key, value);
                }
            });
        }
    }

    protected static byte[] generateEndKey(byte[] prefix) {
        return StorageUtils.generatePrefixEndKey(prefix);
    }

    @Override
    public List<byte[]> get(List<byte @NonNull []> keys) throws StorageException {
        ArrayList<byte[]> values = new ArrayList<byte[]>();
        for (byte[] key : keys) {
            StoreBase.throwIfKeyIsNull(key);
            values.add(this.get(key));
        }
        return values;
    }

    @Override
    public void put(PairList<byte @NonNull [], byte @NonNull []> keysValues) throws StorageException {
        for (int i = 0; i < keysValues.size(); ++i) {
            this.put((byte[])keysValues.getFirst(i), (byte[])keysValues.getSecond(i));
        }
    }

    @Override
    public void remove(List<byte @NonNull []> keys) throws StorageException {
        for (byte[] key : keys) {
            StoreBase.throwIfKeyIsNull(key);
            this.remove(key);
        }
    }

    @Override
    public void removeByPrefix(byte @NonNull [] prefix) throws StorageException {
        this.remove(StorageUtils.listKeysStartingWith(prefix, (IStore)this));
    }

    @Override
    public <T extends IStoreCapability> Optional<T> getCapability(Class<T> capability) {
        return Optional.empty();
    }

    protected static void throwIfKeyIsNull(byte[] key) throws StorageException {
        if (key == null) {
            throw new StorageException("Cannot use null keys!");
        }
    }
}

