/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.lib.commons.collections.ByteArrayWrapper;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class ValueSizeCollectingCallback
implements IKeyValueCallback {
    private final Map<ByteArrayWrapper, Integer> valueSizes = new ConcurrentHashMap<ByteArrayWrapper, Integer>();

    @Override
    public void callback(byte[] key, byte[] value) {
        if (value == null) {
            this.valueSizes.put(new ByteArrayWrapper(key), 0);
        } else {
            this.valueSizes.put(new ByteArrayWrapper(key), value.length);
        }
    }

    public UnmodifiableMap<ByteArrayWrapper, Integer> getValueSizes() {
        return CollectionUtils.asUnmodifiable(this.valueSizes);
    }
}

