/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.abap;

import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.abap.ParsedAbapElementPath;
import org.conqat.engine.abap.UniqueAbapElementName;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class AbapUtils {
    public static final Charset ABAP_ENCODING = StandardCharsets.ISO_8859_1;
    public static final Charset ABAP_ZIP_ENCODING = Charset.forName("Cp437");
    public static final String ABAP_SOURCE_FILE_SUFFIX = ".abap";
    public static final String ABAP_DDIC_FILE_SUFFIX = ".abap_ddic";
    public static final String ABAP_CDS_FILE_SUFFIX = ".abap_cds";
    public static final String ABAP_DDLX_FILE_SUFFIX = ".abap_ddlx";
    public static final String[] ABAP_SOURCE_FILES_PATTERNS = new String[]{"**.abap", "**.abap_ddic", "**.abap_cds"};
    public static final String BW_OBJECTS_PATH_PREFIX = "BW Objects";
    public static final Pattern GENERATED_BW_PROGRAM_NAME = Pattern.compile("GP[A-Z0-9]{25}");
    private static final String UPDATE_DATE_FORMAT = "yyyy-MM-ddHH:mm:ss";
    public static final int MAX_CLASS_NAME_LENGTH = 30;
    public static final char ABAP_TRUE = 'X';
    public static final char ABAP_FALSE = ' ';
    private static final Pattern PACKAGE_NAME_NORMALIZER_PATTERN = Pattern.compile("(Z|Y|/[^/]+/)?(.*)", 2);
    private static final Pattern CCIMP_PATTERN = Pattern.compile("=*CCIMP$");
    private static final Map<String, String> FILE_NAME_TO_ABAP_NAME_REPLACEMENTS = new HashMap<String, String>();

    public static String buildObjectNameFromUniformPath(String uniformPath) throws ConQATException {
        ParsedAbapElementPath parsedPath = new ParsedAbapElementPath(uniformPath);
        return parsedPath.getElementName().getObjectName();
    }

    public static EAbapObjectType buildObjectTypeFromUniformPath(String uniformPath) throws ConQATException {
        ParsedAbapElementPath parsedPath = new ParsedAbapElementPath(uniformPath);
        return parsedPath.getElementName().getObjectType();
    }

    public static String buildFunctionGroupNameFromPath(String uniformPath) throws ConQATException {
        ParsedAbapElementPath parsedPath = new ParsedAbapElementPath(uniformPath);
        if (parsedPath.getElementName().getObjectType() != EAbapObjectType.FUGR) {
            throw new ConQATException(uniformPath + " is not an element of a function group");
        }
        return parsedPath.getFunctionGroup();
    }

    public static String normalizePackage(String packageName) {
        Matcher matcher = PACKAGE_NAME_NORMALIZER_PATTERN.matcher(packageName);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return packageName;
    }

    public static String extractClassName(String classIncludeName) {
        int startPos;
        for (int pos = startPos = Math.min(classIncludeName.length(), 30); pos > 0; --pos) {
            if (classIncludeName.charAt(pos - 1) == '=') continue;
            return classIncludeName.substring(0, pos);
        }
        CCSMAssert.fail((String)"Invalid name of class include.");
        return null;
    }

    public static boolean isProtectedSectionInclude(String objectName) {
        if (objectName.length() < 30) {
            return false;
        }
        return objectName.substring(30).equalsIgnoreCase("co");
    }

    public static boolean isPrivateSectionInclude(String objectName) {
        if (objectName.length() < 30) {
            return false;
        }
        return objectName.substring(30).equalsIgnoreCase("ci");
    }

    public static Date buildUpdateDate(String updateDate, String updateTime, TimeZone timeZone) throws ParseException {
        SimpleDateFormat updateDateFormat = new SimpleDateFormat(UPDATE_DATE_FORMAT);
        updateDateFormat.setTimeZone(timeZone);
        return updateDateFormat.parse(updateDate + updateTime);
    }

    public static boolean hasClassParent(ShallowEntity method) {
        ShallowEntity parent = method.getParent();
        return parent != null && parent.getType() == EShallowEntityType.TYPE && parent.getSubtype().equals("class implementation");
    }

    public static String formatNameForSCOV(ParsedAbapElementPath abapPath) {
        UniqueAbapElementName abapName = abapPath.getElementName();
        EAbapObjectType type = abapName.getObjectType();
        String functionGroupName = null;
        if (type == EAbapObjectType.FUGR) {
            functionGroupName = abapPath.getFunctionGroup();
        }
        return AbapUtils.formatNameForSCOV(abapName.getObjectName(), type, functionGroupName);
    }

    private static String formatNameForSCOV(String name, EAbapObjectType objectType, String functionGroupName) {
        return switch (objectType) {
            case EAbapObjectType.FUGR -> functionGroupName;
            case EAbapObjectType.CLAS -> CCIMP_PATTERN.matcher(name).replaceFirst("");
            default -> name;
        };
    }

    public static char toAbapBool(boolean value) {
        if (value) {
            return 'X';
        }
        return ' ';
    }

    public static boolean toBoolean(char abapBool) throws IllegalArgumentException {
        if (abapBool == 'X') {
            return true;
        }
        if (abapBool == ' ') {
            return false;
        }
        throw new IllegalArgumentException("'" + abapBool + "' is not a valid ABAP_BOOL value, ' ' or 'X' expected.");
    }

    public static String convertAntPatternList(String patternListString) throws IllegalArgumentException {
        if (patternListString == null) {
            return null;
        }
        if (patternListString.matches("(^|.*[^*])\\*([^*].*|$)")) {
            throw new IllegalArgumentException("Ant pattern evaluated in ABAP must not contain single '*' wild card.");
        }
        String convertedPatternString = patternListString.replace("#", "##").replace("+", "#+").replace("?", "+").replace("**", "*");
        return StringUtils.concat((Iterable)CollectionUtils.parseMultiValueStringToList((String)convertedPatternString, (boolean)false), (String)",");
    }

    public static String convertFileNameToAbapName(String s, boolean isAbapGitFormat) {
        if (isAbapGitFormat) {
            return s.replace('#', '/').toUpperCase();
        }
        return StringUtils.replaceFromMap((String)s.replace('!', '/'), FILE_NAME_TO_ABAP_NAME_REPLACEMENTS).toUpperCase();
    }

    public static UniqueAbapElementName createElementNameFromPath(String path) {
        return UniqueAbapElementName.of(path);
    }

    public static String formatAbapIdentifier(String identifier) {
        return identifier.replace('/', '!').toUpperCase();
    }

    public static boolean isBwTransformedPath(String path) {
        return UniformPathUtils.extractProject((String)path).equals(BW_OBJECTS_PATH_PREFIX);
    }

    public static boolean isAbapRepositoryObjectFile(String path) {
        return path.endsWith(ABAP_SOURCE_FILE_SUFFIX) || path.endsWith(ABAP_DDIC_FILE_SUFFIX) || path.endsWith(ABAP_CDS_FILE_SUFFIX);
    }

    private AbapUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    static {
        FILE_NAME_TO_ABAP_NAME_REPLACEMENTS.put("#excl#", "!");
        FILE_NAME_TO_ABAP_NAME_REPLACEMENTS.put("#rsol#", "\\");
        FILE_NAME_TO_ABAP_NAME_REPLACEMENTS.put("#lt#", "<");
        FILE_NAME_TO_ABAP_NAME_REPLACEMENTS.put("#gt#", ">");
        FILE_NAME_TO_ABAP_NAME_REPLACEMENTS.put("#colon#", ":");
        FILE_NAME_TO_ABAP_NAME_REPLACEMENTS.put("#verbar#", "|");
        FILE_NAME_TO_ABAP_NAME_REPLACEMENTS.put("#quest#", "?");
        FILE_NAME_TO_ABAP_NAME_REPLACEMENTS.put("#ast#", "*");
        FILE_NAME_TO_ABAP_NAME_REPLACEMENTS.put("#quot#", "\"");
        FILE_NAME_TO_ABAP_NAME_REPLACEMENTS.put("#space#", " ");
    }
}

