/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.dotnet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.system.SystemUtils;

public abstract class DotnetExecutorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private CanonicalFile executable;
    private List<String> command = null;
    private boolean useMono;

    protected void executeProcess() throws IOException, ConQATException {
        List<String> command = this.getCommand();
        DotnetExecutorBase.executeCommand(command);
    }

    private static void executeCommand(List<String> command) throws IOException, ConQATException {
        String commandToLog = StringUtils.concat(command);
        LOGGER.info("Command: " + commandToLog);
        ProcessBuilder builder = new ProcessBuilder(command);
        ProcessUtils.ExecutionResult result = ProcessUtils.execute((ProcessBuilder)builder);
        String stdOut = result.getStdout();
        String stdErr = result.getStderr();
        if (!StringUtils.isEmpty((String)stdErr)) {
            LOGGER.error("The following command logged errors during execution: " + commandToLog);
            LOGGER.error(stdErr);
        }
        if (result.getReturnCode() != 0) {
            DotnetExecutorBase.throwProcessFailure(commandToLog, stdOut, stdErr, result.getReturnCode());
        }
    }

    private static void throwProcessFailure(String commandToLog, String stdOut, String stdErr, int exitValue) throws ConQATException {
        throw new ConQATException("Executing " + commandToLog + StringUtils.LINE_SEPARATOR + "Process failed with exit value " + exitValue + StringUtils.LINE_SEPARATOR + "Standard Error:" + StringUtils.LINE_SEPARATOR + stdErr + StringUtils.LINE_SEPARATOR + "Standard Out:" + StringUtils.LINE_SEPARATOR + stdOut);
    }

    protected void setExecutable(String path) throws ConQATException {
        this.setExecutable(path, true);
    }

    protected void setExecutable(String path, boolean useMono) throws ConQATException {
        try {
            this.executable = new CanonicalFile(path);
            this.useMono = useMono;
            if (!this.executable.exists()) {
                throw new ConQATException("The file " + this.executable.getCanonicalPath() + " does not exist.");
            }
        }
        catch (IOException e) {
            throw new ConQATException("Could not canonize file " + path + ": " + e.getMessage(), (Throwable)e);
        }
    }

    protected void execute(List<String> arguments) throws IOException, ConQATException {
        CCSMAssert.isNotNull((Object)this.executable, (String)"Please call 'setExecutable' before calling 'execute'");
        this.command = new ArrayList<String>();
        if (!this.useMono) {
            if (this.executable.getName().toLowerCase().endsWith(".dll")) {
                this.command.add("dotnet");
                this.command.add("--roll-forward");
                this.command.add("LatestMajor");
            }
        } else if (!SystemUtils.isWindows()) {
            this.command.add("mono");
        }
        this.command.add(this.executable.getCanonicalPath());
        this.command.addAll(arguments);
        this.executeProcess();
    }

    protected List<String> getCommand() {
        return CollectionUtils.asUnmodifiable(this.command);
    }
}

