/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.comparison;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.teamscale.commons.service.client.HttpRequest;
import com.teamscale.commons.service.client.IDeserializationFormat;
import com.teamscale.commons.service.client.ServerDetails;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.commons.service.client.ServiceClientCallable;
import com.teamscale.commons.service.client.ServiceClientUris;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.admin.instance_comparison.EInstanceComparisonStatus;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonComputationMetadata;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonComputationOptions;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonExternalSnapshotIndex;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotCreationIndex;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotDto;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotMetaData;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import com.teamscale.index.admin.instance_import.InstanceCredentials;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.concurrent.ThreadUtils;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.string.StringUtils;

public class InstanceComparisonSnapshotLoader {
    private static final Duration REMOTE_SNAPSHOT_READ_TIMEOUT = Duration.ofMinutes(1L);
    private static final Duration MAX_SNAPSHOT_WAITING_TIME = Duration.ofDays(1L);
    private final IndexLayer indexLayer;
    private final ICancelable cancelable;

    public InstanceComparisonSnapshotLoader(IndexLayer indexLayer, ICancelable cancelable) {
        this.indexLayer = indexLayer;
        this.cancelable = cancelable;
    }

    public static boolean isLegacyInstance(ServerDetails serverDetails) {
        try {
            return HttpRequest.with((ServerDetails)serverDetails, (ServiceClientCallable)HttpRequest.get((IDeserializationFormat)IDeserializationFormat.fromJsonList(String.class), (String)ServiceClientUris.getGlobal((String)"instance-comparison/snapshots/ids", (ServerDetails)serverDetails, (Pair[])new Pair[0]))) == null;
        }
        catch (ServiceCallException e) {
            return false;
        }
    }

    private void verifyNotCanceled() throws ExecutionCanceledException {
        this.cancelable.verifyNotCanceled();
    }

    public InstanceComparisonSnapshotDto getRemoteSnapshot(InstanceComparisonComputationMetadata comparison, InstanceComparisonComputationOptions options) throws ConQATException, ExecutionCanceledException {
        if (options.isExternallyUploadedSnapshot()) {
            InstanceComparisonExternalSnapshotIndex externalSnapshotIndex = (InstanceComparisonExternalSnapshotIndex)this.indexLayer.openGlobalIndex(InstanceComparisonExternalSnapshotIndex.class);
            return externalSnapshotIndex.getSnapshot(options.getRemoteSnapshotId()).orElseThrow(() -> new IllegalStateException("Could not find externally uploaded snapshot with name: " + options.getRemoteSnapshotId()));
        }
        try {
            return this.fetchRemoteSnapshot(options.getRemoteSnapshotId(), options.getRemoteInstanceCredentials().orElseThrow(() -> new IllegalStateException("Remote credentials are not present")), Instant.ofEpochMilli(comparison.getCreatedOn()), comparison.getId());
        }
        catch (ServiceCallException e) {
            throw new ConQATException("Failed to read remote snapshot " + comparison.getOptions().getRemoteSnapshotId(), (Throwable)e);
        }
    }

    public InstanceComparisonSnapshotDto.InstanceComparisonSnapshotContributions readLocalSnapshot(String localSnapshotId, Instant start, String comparisonId) throws ConQATException, ExecutionCanceledException {
        InstanceComparisonSnapshotCreationIndex statusIndex = (InstanceComparisonSnapshotCreationIndex)this.indexLayer.openGlobalIndex(InstanceComparisonSnapshotCreationIndex.class);
        while (true) {
            this.verifyNotCanceled();
            InstanceComparisonSnapshotMetaData snapshotMetaData = statusIndex.getSnapshotMetaData(localSnapshotId).orElseThrow(() -> new ConQATException("No local snapshot with ID %s found".formatted(localSnapshotId)));
            if (snapshotMetaData.getStatus() == EInstanceComparisonStatus.FAILURE) {
                throw new ConQATException("Cannot compute comparison of failed snapshot " + localSnapshotId);
            }
            if (snapshotMetaData.getStatus() == EInstanceComparisonStatus.SUCCESS) {
                List<InstanceComparisonContributionBase> contributions = statusIndex.getAllSnapshotContributions(localSnapshotId);
                return InstanceComparisonSnapshotDto.InstanceComparisonSnapshotContributions.of(contributions);
            }
            InstanceComparisonSnapshotLoader.throwIfTimedOut(start, comparisonId);
            ThreadUtils.sleep((long)1000L);
        }
    }

    private static void throwIfTimedOut(Instant start, String comparisonId) throws ConQATException {
        boolean timeout;
        boolean bl = timeout = Duration.between(start, DateTimeUtils.now()).compareTo(MAX_SNAPSHOT_WAITING_TIME) > 0;
        if (timeout) {
            throw new ConQATException("The comparison with ID " + comparisonId + " took to long to process.");
        }
    }

    private InstanceComparisonSnapshotDto fetchRemoteSnapshot(String remoteSnapshotId, InstanceCredentials remoteInstanceCredentials, Instant start, String comparisonId) throws ServiceCallException, ConQATException, ExecutionCanceledException {
        ServerDetails serverDetails = remoteInstanceCredentials.toServerDetails().withTimeOut(REMOTE_SNAPSHOT_READ_TIMEOUT);
        if (InstanceComparisonSnapshotLoader.isLegacyInstance(serverDetails)) {
            throw new ConQATException("Remote instance does not support instance comparison!");
        }
        if (StringUtils.isEmpty((String)remoteSnapshotId)) {
            remoteSnapshotId = InstanceComparisonSnapshotLoader.determineSnapshotId(serverDetails);
        }
        while (true) {
            this.verifyNotCanceled();
            EInstanceComparisonStatus remoteSnapshotStatus = InstanceComparisonSnapshotLoader.fetchRemoteSnapshotStatus(serverDetails, remoteSnapshotId);
            if (remoteSnapshotStatus == EInstanceComparisonStatus.FAILURE) {
                throw new ConQATException("Remote instance failed to provide snapshot (debug failure reason in remote worker log): " + remoteSnapshotId);
            }
            if (remoteSnapshotStatus == EInstanceComparisonStatus.SUCCESS) {
                return InstanceComparisonSnapshotLoader.doFetchRemoteSnapshot(remoteSnapshotId, serverDetails);
            }
            InstanceComparisonSnapshotLoader.throwIfTimedOut(start, comparisonId);
            ThreadUtils.sleep((long)1000L);
        }
    }

    private static InstanceComparisonSnapshotDto doFetchRemoteSnapshot(String remoteSnapshotId, ServerDetails serverDetails) throws ServiceCallException {
        InstanceComparisonSnapshotLoader.checkPreconditions(serverDetails.getUrl(), remoteSnapshotId);
        return (InstanceComparisonSnapshotDto)HttpRequest.with((ServerDetails)serverDetails, (ServiceClientCallable)HttpRequest.get((IDeserializationFormat)IDeserializationFormat.fromJson(InstanceComparisonSnapshotDto.class), (String)ServiceClientUris.getGlobal((String)("instance-comparison/snapshots/" + remoteSnapshotId), (ServerDetails)serverDetails, (Pair[])new Pair[0])));
    }

    private static EInstanceComparisonStatus fetchRemoteSnapshotStatus(ServerDetails serverDetails, String remoteSnapshotId) throws ServiceCallException {
        InstanceComparisonSnapshotLoader.checkPreconditions(serverDetails.getUrl(), remoteSnapshotId);
        EInstanceComparisonStatus remoteSnapshotStatus = (EInstanceComparisonStatus)((Object)HttpRequest.with((ServerDetails)serverDetails, (ServiceClientCallable)HttpRequest.get((IDeserializationFormat)IDeserializationFormat.fromJson(EInstanceComparisonStatus.class), (String)ServiceClientUris.getGlobal((String)("instance-comparison/snapshots/" + remoteSnapshotId + "/status"), (ServerDetails)serverDetails, (Pair[])new Pair[0]))));
        if (remoteSnapshotStatus == null) {
            throw new ServiceCallException("Service call failed: Status of snapshot with ID " + remoteSnapshotId + " was not found.");
        }
        return remoteSnapshotStatus;
    }

    private static void checkPreconditions(String remoteUrl, String remoteSnapshotId) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)remoteUrl) ? 1 : 0) != 0, (Object)"Remote URL must be given");
        Preconditions.checkArgument((!StringUtils.isEmpty((String)remoteSnapshotId) ? 1 : 0) != 0, (Object)"Remote snapshot ID must be given");
        Preconditions.checkArgument((boolean)remoteUrl.startsWith("http"), (String)"Remote Teamscale URL \"%s\" doesn't have a valid protocol", (Object)remoteUrl);
    }

    private static String determineSnapshotId(ServerDetails remoteInstanceServerDetails) throws ServiceCallException, ConQATException {
        List snapshotIds = (List)HttpRequest.with((ServerDetails)remoteInstanceServerDetails, (ServiceClientCallable)HttpRequest.get((IDeserializationFormat)IDeserializationFormat.fromJsonList(String.class), (String)ServiceClientUris.getGlobal((String)"instance-comparison/snapshots/ids", (ServerDetails)remoteInstanceServerDetails, (Pair[])new Pair[0])));
        if (snapshotIds.isEmpty()) {
            throw new ConQATException("No snapshots found on remote instance.");
        }
        if (snapshotIds.size() > 1) {
            throw new ConQATException("More than one snapshot found on remote instance.");
        }
        return (String)Iterables.getOnlyElement((Iterable)snapshotIds);
    }
}

