/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup.write;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.index.backup.BackupTargetFactory;
import com.teamscale.index.backup.EBackupStatus;
import com.teamscale.index.backup.IBackupTarget;
import com.teamscale.index.backup.StatusReportingTriggerBase;
import com.teamscale.index.backup.TemporaryFileIndex;
import com.teamscale.index.backup.write.BackupExportStatus;
import com.teamscale.index.backup.write.BackupExportStatusIndex;
import com.teamscale.index.backup.write.BackupWriter;
import com.teamscale.index.backup.write.BackupWritingParameters;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.persistence.store.StorageException;

public class BackupExportTrigger
extends StatusReportingTriggerBase<BackupExportStatus, BackupExportStatusIndex> {
    private static final Logger LOGGER = LogManager.getLogger();

    public BackupExportTrigger() {
        super(BackupExportStatusIndex.class);
    }

    @Override
    protected void performAction() throws StorageException {
        ExternalCredentialsIndex externalCredentialsIndex = (ExternalCredentialsIndex)this.indexLayer.openGlobalIndex(ExternalCredentialsIndex.class);
        TemporaryFileIndex fileIndex = (TemporaryFileIndex)this.indexLayer.openGlobalIndex(TemporaryFileIndex.class);
        try {
            this.verifyNotCanceled();
            IBackupTarget target = BackupTargetFactory.getWriteTarget(((BackupExportStatus)this.status).getBackupExportOptions().getBackupTarget(), externalCredentialsIndex, fileIndex, LOGGER);
            new BackupWriter(new BackupWritingParameters(((BackupExportStatus)this.status).getBackupExportOptions(), this.indexLayer, this.lockProvider, (File)this.getTemporaryDirectory(), this.instanceConfiguration), (ICancelable)this).writeBackupZip(target.getOutputStream(), (BackupExportStatus)this.status);
            target.completeBackup();
            ((BackupExportStatus)this.status).setStatusAndMessage(EBackupStatus.SUCCESS, "Backup export completed!");
        }
        catch (ExecutionCanceledException e) {
            ((BackupExportStatus)this.status).setStatusAndMessage(EBackupStatus.FAILURE, e.getMessage());
        }
        catch (IOException e) {
            ((BackupExportStatus)this.status).setStatusAndMessage(EBackupStatus.FAILURE, "Failed to write backup: " + e.getMessage());
            LOGGER.error("Failed to write backup", (Throwable)e);
        }
    }

    public ETriggerConcurrency getConcurrency() {
        return ETriggerConcurrency.MAINTENANCE_PARALLEL;
    }
}

