/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_change.refactoring_detection;

import com.teamscale.index.code_change.MethodMatchRegion;
import com.teamscale.index.code_change.refactoring_detection.ELocalRefactoringDetectionResult;
import com.teamscale.index.code_change.refactoring_detection.ILocalRefactoringDetector;
import com.teamscale.index.code_change.refactoring_detection.IMethodRefactoringDetectorStrategy;
import com.teamscale.index.code_change.refactoring_detection.IgnoredTokenTypeDetector;
import com.teamscale.index.code_change.refactoring_detection.MethodCallPatternMapping;
import com.teamscale.index.code_change.refactoring_detection.ParallelTokenListIterator;
import com.teamscale.index.code_change.refactoring_detection.RenameDetector;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.typetracker.TypeTrackerFactory;
import eu.cqse.check.framework.typetracker.TypedVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.algo.Diff;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;

public abstract class MethodRefactoringDetectorStrategyBase
implements IMethodRefactoringDetectorStrategy {
    protected ELanguage language;
    protected RenameDetector renameDetector;
    protected ITypeResolution oldTypeResolution;
    protected ITypeResolution newTypeResolution;
    protected List<ILocalRefactoringDetector> detectors = new ArrayList<ILocalRefactoringDetector>();
    private final Map<Pair<ShallowEntity, ShallowEntity>, Boolean> equalityCache = new HashMap<Pair<ShallowEntity, ShallowEntity>, Boolean>();
    protected MethodCallPatternMapping methodCallPatternMapping = new MethodCallPatternMapping();

    public MethodRefactoringDetectorStrategyBase(ELanguage language, RenameDetector renameDetector) {
        this.language = language;
        this.renameDetector = renameDetector;
        this.detectors.add(this::detectVariableRename);
        this.detectors.add(this::detectUnchangedTokens);
        this.detectors.add(this::detectMethodRename);
        this.detectors.add(this::detectClassRename);
        this.detectors.add(new IgnoredTokenTypeDetector(this.getIgnoredTokenTypes()));
    }

    @Override
    public boolean containsRefactoringsOnly(MethodMatchRegion newMethod) {
        this.renameDetector.reset();
        MethodMatchRegion oldMethod = (MethodMatchRegion)newMethod.getMatch();
        CCSMAssert.isNotNull((Object)((Object)oldMethod));
        CCSMAssert.isNotNull((Object)oldMethod.getContent());
        CCSMAssert.isNotNull((Object)newMethod.getContent());
        ShallowEntity oldEntity = oldMethod.getContent().getEntity();
        ShallowEntity newEntity = newMethod.getContent().getEntity();
        CCSMAssert.isTrue((boolean)TypeTrackerFactory.supportsLanguage((ELanguage)this.language), (String)("Type tracker needs to be implemented for " + String.valueOf(this.language) + " in order to use MethodRefactoringDetectorBase!"));
        this.oldTypeResolution = TypeTrackerFactory.createTypeTracker((ELanguage)this.language).createTypeResolution(Collections.singletonList(oldEntity), MethodRefactoringDetectorStrategyBase.scopedTypeLookupOfParameters(oldMethod));
        this.newTypeResolution = TypeTrackerFactory.createTypeTracker((ELanguage)this.language).createTypeResolution(Collections.singletonList(newEntity), MethodRefactoringDetectorStrategyBase.scopedTypeLookupOfParameters(newMethod));
        this.initializeVariableRenamesWithParameters(oldMethod, newMethod);
        return this.entitiesEqual(oldEntity, newEntity);
    }

    private static ScopedTypeLookup scopedTypeLookupOfParameters(MethodMatchRegion method) {
        ScopedTypeLookup variableLookup = new ScopedTypeLookup();
        for (TypedVariable parameter : method.getParameters()) {
            variableLookup.putTypeInfo(parameter.getVariableName(), parameter);
        }
        return variableLookup;
    }

    private void initializeVariableRenamesWithParameters(MethodMatchRegion oldMethod, MethodMatchRegion newMethod) {
        int minSize = Math.min(oldMethod.getParameters().size(), newMethod.getParameters().size());
        for (int i = 0; i < minSize; ++i) {
            this.renameDetector.isValidVariableRenaming(oldMethod.getParameters().get(i), newMethod.getParameters().get(i));
        }
    }

    protected boolean entitiesEqual(ShallowEntity oldEntity, ShallowEntity newEntity) {
        UnmodifiableList newChildren;
        Boolean cachedValue = this.equalityCache.get(Pair.createPair((Object)oldEntity, (Object)newEntity));
        if (cachedValue != null) {
            return cachedValue;
        }
        this.renameDetector.enterScope();
        if (!oldEntity.hasChildren() || !newEntity.hasChildren()) {
            boolean result = this.areStatementsEqual(oldEntity, (List<IToken>)oldEntity.includedTokens(), newEntity, (List<IToken>)newEntity.includedTokens());
            this.renameDetector.exitScope();
            return result;
        }
        if (!this.areOwnStartAndEndTokensEqual(oldEntity, newEntity)) {
            this.renameDetector.exitScope();
            return false;
        }
        UnmodifiableList oldChildren = oldEntity.getChildren();
        Diff.Delta delta = Diff.computeDelta((List)oldChildren, (List)(newChildren = newEntity.getChildren()), this::entitiesEqual);
        if (delta.getSize() == 0) {
            this.renameDetector.exitScope();
            this.equalityCache.put((Pair<ShallowEntity, ShallowEntity>)Pair.createPair((Object)oldEntity, (Object)newEntity), true);
            return true;
        }
        boolean result = this.childrenDeltaContainsRefactoringsOnly((Diff.Delta<ShallowEntity>)delta);
        this.renameDetector.exitScope();
        this.equalityCache.put((Pair<ShallowEntity, ShallowEntity>)Pair.createPair((Object)oldEntity, (Object)newEntity), result);
        return result;
    }

    protected boolean areOwnStartAndEndTokensEqual(ShallowEntity oldEntity, ShallowEntity newEntity) {
        return this.areStatementsEqual(oldEntity, (List<IToken>)oldEntity.ownStartTokens(), newEntity, (List<IToken>)newEntity.ownStartTokens()) && this.areStatementsEqual(oldEntity, (List<IToken>)oldEntity.ownEndTokens(), newEntity, (List<IToken>)newEntity.ownEndTokens());
    }

    protected abstract boolean childrenDeltaContainsRefactoringsOnly(Diff.Delta<ShallowEntity> var1);

    protected boolean areStatementsEqual(ShallowEntity oldEntity, List<IToken> oldTokens, ShallowEntity newEntity, List<IToken> newTokens) {
        ParallelTokenListIterator parallelTokenListIterator = new ParallelTokenListIterator(oldTokens, this.oldTypeResolution.getTypeLookup(oldEntity), newTokens, this.newTypeResolution.getTypeLookup(newEntity));
        while (parallelTokenListIterator.hasMoreTokens() && !this.foundEssentialChange(parallelTokenListIterator)) {
            parallelTokenListIterator.next();
        }
        return parallelTokenListIterator.bothEndsReached();
    }

    private boolean foundEssentialChange(ParallelTokenListIterator parallelTokenListIterator) {
        for (ILocalRefactoringDetector detection : this.detectors) {
            int oldStartPos = parallelTokenListIterator.getOldTokenListIterator().getTokenPos();
            int newStartPos = parallelTokenListIterator.getNewTokenListIterator().getTokenPos();
            ELocalRefactoringDetectionResult result = detection.process(parallelTokenListIterator);
            if (result == ELocalRefactoringDetectionResult.REAL_CHANGE) {
                return true;
            }
            if (result == ELocalRefactoringDetectionResult.REFACTORING) {
                return false;
            }
            parallelTokenListIterator.getOldTokenListIterator().setTokenPos(oldStartPos);
            parallelTokenListIterator.getNewTokenListIterator().setTokenPos(newStartPos);
        }
        return true;
    }

    private ELocalRefactoringDetectionResult detectUnchangedTokens(ParallelTokenListIterator tokenListIterator) {
        if (tokenListIterator.tokenNameAndTypesEqual()) {
            return ELocalRefactoringDetectionResult.REFACTORING;
        }
        return ELocalRefactoringDetectionResult.NO_DECISION;
    }

    protected EnumSet<ETokenType> getRenameableTokenTypes() {
        return EnumSet.of(ETokenType.IDENTIFIER);
    }

    protected EnumSet<ETokenType> getIgnoredTokenTypes() {
        return EnumSet.noneOf(ETokenType.class);
    }

    protected ELocalRefactoringDetectionResult detectVariableRename(ParallelTokenListIterator tokenListIterator) {
        TypedVariable oldVariable = tokenListIterator.getOldTypeInfo(tokenListIterator.getOldTokenText());
        TypedVariable newVariable = tokenListIterator.getNewTypeInfo(tokenListIterator.getNewTokenText());
        return this.detectVariableRename(tokenListIterator, oldVariable, newVariable);
    }

    protected ELocalRefactoringDetectionResult detectVariableRename(ParallelTokenListIterator tokenListIterator, TypedVariable oldVariable, TypedVariable newVariable) {
        if (tokenListIterator.bothAreAnyOfType(this.getRenameableTokenTypes())) {
            if (oldVariable != null && newVariable != null) {
                if (this.renameDetector.isValidVariableRenaming(oldVariable, newVariable)) {
                    return ELocalRefactoringDetectionResult.REFACTORING;
                }
                return ELocalRefactoringDetectionResult.REAL_CHANGE;
            }
            return ELocalRefactoringDetectionResult.NO_DECISION;
        }
        return ELocalRefactoringDetectionResult.NO_DECISION;
    }

    protected ELocalRefactoringDetectionResult detectMethodRename(ParallelTokenListIterator parallelTokenListIterator) {
        if (this.isMethodInvocation(parallelTokenListIterator)) {
            return this.detectMethodRename(parallelTokenListIterator.getOldTokenText(), parallelTokenListIterator.getNewTokenText());
        }
        return ELocalRefactoringDetectionResult.NO_DECISION;
    }

    protected ELocalRefactoringDetectionResult detectMethodRename(String oldMethodName, String newMethodName) {
        if (!this.renameDetector.existsMethodRenamingRuleFor(oldMethodName)) {
            return ELocalRefactoringDetectionResult.NO_DECISION;
        }
        if (this.renameDetector.isValidMethodRenaming(oldMethodName, newMethodName)) {
            return ELocalRefactoringDetectionResult.REFACTORING;
        }
        return ELocalRefactoringDetectionResult.REAL_CHANGE;
    }

    protected abstract boolean isMethodInvocation(ParallelTokenListIterator var1);

    protected ELocalRefactoringDetectionResult detectClassRename(ParallelTokenListIterator parallelTokenListIterator) {
        if (!parallelTokenListIterator.bothAreAnyOfType(this.getRenameableTokenTypes())) {
            return ELocalRefactoringDetectionResult.NO_DECISION;
        }
        String oldClassName = parallelTokenListIterator.getOldTokenText();
        if (!this.renameDetector.existsClassRenamingRuleFor(oldClassName)) {
            return ELocalRefactoringDetectionResult.NO_DECISION;
        }
        if (this.renameDetector.isValidClassRenaming(oldClassName, parallelTokenListIterator.getNewTokenText())) {
            return ELocalRefactoringDetectionResult.REFACTORING;
        }
        return ELocalRefactoringDetectionResult.REAL_CHANGE;
    }

    @Override
    public void addAllMatchedMethods(List<MethodMatchRegion> matchedMethods) {
    }
}

