/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.detection;

import com.google.common.base.Preconditions;
import com.teamscale.index.code_clones.core.Clone;
import com.teamscale.index.code_clones.detection.CloneChunk;
import com.teamscale.index.code_clones.detection.CloneIndexCloneSearcher;
import com.teamscale.index.code_clones.report.ICloneClassReporter;
import com.teamscale.index.code_clones.suffixtree.ICloneReporter;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

public class IntraComponentCloneIndexCloneSearcher
implements ICloneReporter {
    private final CloneIndexCloneSearcher underlyingCloneSearcher;
    private final String currentComponent;

    public IntraComponentCloneIndexCloneSearcher(@NonNull String componentName, @NonNull Set<String> originIds, @NonNull ICloneClassReporter reporter, int minLength, @NonNull List<CloneChunk> chunks, int chunkLength) {
        Preconditions.checkNotNull(originIds);
        Preconditions.checkNotNull((Object)reporter);
        Preconditions.checkNotNull(chunks);
        Preconditions.checkArgument((!StringUtils.isEmpty((String)componentName) ? 1 : 0) != 0);
        this.underlyingCloneSearcher = new CloneIndexCloneSearcher(originIds, reporter, minLength, chunks, chunkLength);
        this.currentComponent = componentName;
    }

    @Override
    public boolean startCloneClass(int normalizedLength, int numberOfClones) {
        return this.underlyingCloneSearcher.startCloneClass(normalizedLength, numberOfClones);
    }

    @Override
    public Clone addClone(int startPosition, int length) {
        Clone clone = this.underlyingCloneSearcher.addClone(startPosition, length);
        clone.setComponent(this.currentComponent);
        return clone;
    }

    @Override
    public boolean completeCloneClass() throws StorageException {
        return this.underlyingCloneSearcher.completeCloneClass();
    }

    public void reportClones() throws StorageException {
        this.underlyingCloneSearcher.reportClonesWithExternalReporter(this);
    }
}

