/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.index.configuration.SimulinkAnalysisConfigurationBase;
import com.teamscale.index.simulink.analysis.naming_convention.SimulinkNamingConventionAnalysis;
import com.teamscale.index.simulink.analysis.naming_convention.SimulinkNamingConventionAnalysisRunner;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.scanner.ELanguage;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Base64;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Optional;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.string.StringUtils;

public class SimulinkNamingConventionAnalysisConfiguration
extends SimulinkAnalysisConfigurationBase {
    @ConfigExposed(name="Sub Expressions", description="Sub expressions that can be used in naming patterns. One sub expression per line:  <expressionName>=<pattern> . Whitespace-only lines and lines starting with // are ignored. Whitespace before/after <expressionName> and <pattern> is ignored. Sub expressions can't use other sub expressions.", visibility=ConfigExposed.EConfigVisibility.DEFAULT, multilineText=true)
    public String subExpressions = "$AlphaNum=[a-z|A-Z|0-9]";
    @ConfigExposed(name="Enable checking of reference blocks", description="When enabled, names of reference blocks are checked.\nIf a reference block references, e.g., \"libraryX/SYS_name\", the block's name must start with \"SYS_\".\nThis check uses the \"$SYS\" subexpression to identify system identifiers and only works if a subexpression named \"$SYS\" is set.", visibility=ConfigExposed.EConfigVisibility.DEFAULT)
    public Boolean enableReferenceBlockCheck = true;
    @ConfigExposed(name="Signal-Name Pattern", description="Pattern for Signal Names. Can use the configured sub expressions.", visibility=ConfigExposed.EConfigVisibility.DEFAULT)
    public String signalNamePattern = "$AlphaNum+";
    @ConfigExposed(name="Port-Name Pattern (standard)", description="Pattern for Standard Port Names. This includes all ports that are not top level, in a library or in a subsystem. Can use the configured sub expressions.", visibility=ConfigExposed.EConfigVisibility.DEFAULT)
    public String standardPortNamePattern = "$AlphaNum+";
    @ConfigExposed(name="Port-Name Pattern (Root Ports)", description="Pattern for Root Port Names. This includes all ports that are top level, not in a library and not in a subsystem. Can use the configured sub expressions.", visibility=ConfigExposed.EConfigVisibility.DEFAULT)
    public String rootPortNamePattern = "$AlphaNum+";
    @ConfigExposed(name="Subsystem Instance Pattern", description="Pattern describing naming conventions for subsystem blocks.", visibility=ConfigExposed.EConfigVisibility.DEFAULT)
    public String subsystemInstanceNamePattern = "$AlphaNum+";
    @ConfigExposed(name="Ignored Block Types", description="Ignored Block Types. Separated by a comma.", visibility=ConfigExposed.EConfigVisibility.DEFAULT)
    public String ignoredBlockTypes = "";
    @ConfigExposed(name="Library Subsystem Pattern", description="Pattern describing naming conventions for library subsystem blocks.", visibility=ConfigExposed.EConfigVisibility.DEFAULT)
    public String librarySubsystemNamePattern = "$AlphaNum+";
    @ConfigExposed(name="Global Library Subsystem Pattern", description="Pattern describing naming conventions for global-library subsystem blocks.", visibility=ConfigExposed.EConfigVisibility.DEFAULT)
    public String globalLibrarySubsystemNamePattern = "$AlphaNum+";
    @ConfigExposed(name="Global Library Path Pattern", description="Pattern describing the path(s) containing global libraries. An empty pattern matches on no path.", visibility=ConfigExposed.EConfigVisibility.DEFAULT)
    public String globalLibraryPathPattern = "$AlphaNum+";

    public SimulinkNamingConventionAnalysisConfiguration() {
        this.autoExpose();
        FindingDescriptor namingConventionFindingDescriptor = new FindingDescriptor("Simulink naming", EAnalysisTool.TEAMSCALE, EnumSet.of(ELanguage.SIMULINK), EFindingEnablement.OFF, "Violation of the Simulink naming conventions.");
        this.findingAnalyses.add(SimulinkNamingConventionAnalysis.class, (Object)namingConventionFindingDescriptor);
        this.addFindingDescriptor(namingConventionFindingDescriptor);
    }

    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        TriggerBuilder triggerBuilder = new TriggerBuilder(SimulinkNamingConventionAnalysisRunner.class);
        this.configureMetrics(proxy, triggerBuilder);
        Optional indexOfNamingConventionAnalysis = this.findingAnalyses.indexOfFirst(SimulinkNamingConventionAnalysis.class);
        if (indexOfNamingConventionAnalysis.isPresent()) {
            String enrichedFindingDescription = "Violation of the Simulink naming conventions.\nSubExpressions:  \n\n\t" + String.join((CharSequence)"\n\n\t", StringUtils.splitLinesAsList((String)this.subExpressions));
            FindingDescriptor findingDescriptorStub = (FindingDescriptor)this.findingAnalyses.getSecond(((Integer)indexOfNamingConventionAnalysis.get()).intValue());
            FindingDescriptor newFindingDescriptor = findingDescriptorStub.cloneWithUpdatedFindingDescription(enrichedFindingDescription);
            this.findingAnalyses.setSecond(((Integer)indexOfNamingConventionAnalysis.get()).intValue(), (Object)newFindingDescriptor);
        }
        this.configureFindings(proxy, triggerBuilder, "Comprehensibility");
        HashMap<String, String> parameterMap = this.buildParameterMap();
        try {
            triggerBuilder.setTriggerParameter("serialized-parameter-map", Base64.getEncoder().encodeToString(StorageUtils.serialize(parameterMap)));
        }
        catch (StorageException e) {
            throw new ProjectConfigurationException("IO Exception while serializing parameter to pass them to analysis.", (Throwable)e);
        }
        proxy.createTrigger(triggerBuilder);
    }

    public HashMap<String, String> buildParameterMap() {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("Sub Expressions", this.subExpressions);
        parameterMap.put("Port-Name Pattern (Root Ports)", this.rootPortNamePattern);
        parameterMap.put("Port-Name Pattern (standard)", this.standardPortNamePattern);
        parameterMap.put("Subsystem Instance Pattern", this.subsystemInstanceNamePattern);
        parameterMap.put("Signal-Name Pattern", this.signalNamePattern);
        parameterMap.put("Library Subsystem Pattern", this.librarySubsystemNamePattern);
        parameterMap.put("Global Library Subsystem Pattern", this.globalLibrarySubsystemNamePattern);
        parameterMap.put("Ignored Block Types", this.ignoredBlockTypes);
        parameterMap.put("Global Library Path Pattern", this.globalLibraryPathPattern);
        parameterMap.put("Enable checking of reference blocks", Boolean.toString(this.enableReferenceBlockCheck));
        return parameterMap;
    }

    @Override
    protected void addFindingsToAnalysisGroups(ConfigurationTemplate configurationTemplate) {
        super.addFindingsToAnalysisGroups(configurationTemplate);
        ArrayList<ConfigOptionDescriptorBase> items = new ArrayList<ConfigOptionDescriptorBase>();
        for (Field field : ((Object)((Object)this)).getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigExposed.class)) continue;
            items.add(this.getOptionForField(field.getName()));
        }
        configurationTemplate.registerConfigurationItems("Naming", "Comprehensibility", items);
    }
}

