/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class TargetTriple {
    private final Architecture architecture;
    private final Vendor vendor;
    private final OperatingSystem os;
    private final Environment environment;
    private final ObjectFormat objectFormat;

    public TargetTriple(@Nullable String architecture, @Nullable String vendor, @Nullable String os, @Nullable String environment, @Nullable String objectFormat) {
        this.architecture = Architecture.fromString(architecture);
        this.vendor = Vendor.fromString(vendor);
        this.os = OperatingSystem.fromString(os);
        this.environment = environment != null ? Environment.fromString(environment) : null;
        this.objectFormat = objectFormat != null ? ObjectFormat.fromString(objectFormat) : null;
    }

    public Architecture getArchitecture() {
        return this.architecture;
    }

    public Vendor getVendor() {
        return this.vendor;
    }

    public @NonNull OperatingSystem getOs() {
        return this.os;
    }

    public @Nullable Environment getEnvironment() {
        return this.environment;
    }

    public @Nullable ObjectFormat getObjectFormat() {
        return this.objectFormat;
    }

    public String getTargetTripleString() {
        String tripleString = String.valueOf((Object)this.architecture) + "-" + String.valueOf((Object)this.vendor) + "-" + String.valueOf((Object)this.os);
        if (this.environment != null) {
            tripleString = tripleString + "-" + String.valueOf((Object)this.environment);
        }
        if (this.objectFormat != null) {
            tripleString = tripleString + "-" + String.valueOf((Object)this.objectFormat);
        }
        return tripleString;
    }

    public static enum Architecture {
        AARCH64("aarch64", "arm64", "arm64e", "arm64ec"),
        AARCH64_32("aarch64_32", "arm64_32"),
        AARCH64_BE("aarch64_be"),
        AMDGCN("amdgcn"),
        AMDIL64("amdil64"),
        AMDIL("amdil"),
        ARC("arc"),
        ARM("arm", "xscale"),
        ARMEB("armeb", "xscaleeb"),
        AVR("avr"),
        BPFEB("bpfeb"),
        BPFEL("bpfel"),
        CSKY("csky"),
        DXIL("dxil", "dxilv1.0", "dxilv1.1", "dxilv1.2", "dxilv1.3", "dxilv1.4", "dxilv1.5", "dxilv1.6", "dxilv1.7", "dxilv1.8"),
        HEXAGON("hexagon"),
        HSAIL64("hsail64"),
        HSAIL("hsail"),
        KALIMBA("kalimba"),
        LANAI("lanai"),
        LOONGARCH32("loongarch32"),
        LOONGARCH64("loongarch64"),
        M68K("m68k"),
        MIPS64("mips64", "mips64eb", "mipsn32", "mipsisa64r6", "mips64r6", "mipsn32r6"),
        MIPS64EL("mips64el", "mipsn32el", "mipsisa64r6el", "mips64r6el", "mipsn32r6el"),
        MIPS("mips", "mipseb", "mipsallegrex", "mipsisa32r6", "mipsr6"),
        MIPSEL("mipsel", "mipsallegrexel", "mipsisa32r6el", "mipsr6el"),
        MSP430("msp430"),
        NVPTX64("nvptx64"),
        NVPTX("nvptx"),
        PPC64("powerpc64", "ppu", "ppc64"),
        PPC64LE("ppc64le", "powerpc64le"),
        PPC("powerpc", "powerpcspe", "ppc", "ppc32"),
        PPCLE("powerpcle", "ppcle", "ppc32le"),
        R600("r600"),
        RENDERSCRIPT32("renderscript32"),
        RENDERSCRIPT64("renderscript64"),
        RISCV32("riscv32"),
        RISCV64("riscv64"),
        SHAVE("shave"),
        SPARC("sparc"),
        SPARCEL("sparcel"),
        SPARCV9("sparcv9", "sparc64"),
        SPIR64("spir64"),
        SPIR("spir"),
        SPIRV("spirv", "spirv1.5", "spirv1.6"),
        SPIRV32("spirv32", "spirv32v1.0", "spirv32v1.1", "spirv32v1.2", "spirv32v1.3", "spirv32v1.4", "spirv32v1.5", "spirv32v1.6"),
        SPIRV64("spirv64", "spirv64v1.0", "spirv64v1.1", "spirv64v1.2", "spirv64v1.3", "spirv64v1.4", "spirv64v1.5", "spirv64v1.6"),
        SYSTEMZ("systemz", "s390x"),
        TCE("tce"),
        TCELE("tcele"),
        THUMB("thumb"),
        THUMBEB("thumbeb"),
        VE("ve"),
        WASM32("wasm32"),
        WASM64("wasm64"),
        X86("x86"),
        X86_64("x86_64", "amd64", "x86_64h"),
        XCORE("xcore"),
        XTENSA("xtensa"),
        UNKNOWN("unknown");

        private final String[] names;
        private static final Pattern I386_PATTERN;

        private Architecture(String ... names) {
            this.names = names;
        }

        public String[] getNames() {
            return this.names;
        }

        public static Architecture fromString(String archStr) {
            if (archStr == null || archStr.isEmpty()) {
                return UNKNOWN;
            }
            String archStrLowerCase = archStr.toLowerCase();
            for (Architecture arch : Architecture.values()) {
                if (arch == UNKNOWN) continue;
                for (String name : arch.names) {
                    if (!archStrLowerCase.equals(name)) continue;
                    return arch;
                }
            }
            if (archStrLowerCase.startsWith("kalimba")) {
                return KALIMBA;
            }
            if (I386_PATTERN.matcher(archStrLowerCase).matches()) {
                return X86;
            }
            return UNKNOWN;
        }

        static {
            I386_PATTERN = Pattern.compile("i[3-9]86");
        }
    }

    public static enum Vendor {
        AMD("amd"),
        APPLE("apple"),
        CSR("csr"),
        FREESCALE("fsl", "freescale"),
        IBM("ibm"),
        IMAGINATION_TECHNOLOGIES("img"),
        INTEL("intel"),
        MESA("mesa"),
        MIPS_TECHNOLOGIES("mti"),
        NVIDIA("nvidia"),
        OPEN_EMBEDDED("oe"),
        PC("pc"),
        SCEI("scei", "sie"),
        SUSE("suse"),
        UNKNOWN("unknown");

        private final String[] names;

        private Vendor(String ... names) {
            this.names = names;
        }

        public String[] getNames() {
            return this.names;
        }

        public static Vendor fromString(String vendorStr) {
            if (vendorStr == null || vendorStr.isEmpty()) {
                return UNKNOWN;
            }
            String vendorStrLowerCase = vendorStr.toLowerCase();
            for (Vendor vendor : Vendor.values()) {
                if (!Arrays.stream(vendor.names).anyMatch(vendorStrLowerCase::equals)) continue;
                return vendor;
            }
            return UNKNOWN;
        }
    }

    public static enum OperatingSystem {
        AIX("aix"),
        AMDHSA("amdhsa"),
        AMDPAL("amdpal"),
        BRIDGEOS("bridgeos"),
        CUDA("cuda"),
        DARWIN("darwin"),
        DRAGONFLY("dragonfly"),
        DRIVER_KIT("driverkit"),
        ELFIAMCU("elfiamcu"),
        EMSCRIPTEN("emscripten"),
        FREEBSD("freebsd"),
        FUCHSIA("fuchsia"),
        HAIKU("haiku"),
        HERMIT_CORE("hermit"),
        HURD("hurd"),
        IOS("ios"),
        KFREEBSD("kfreebsd"),
        LINUX("linux"),
        LV2("lv2"),
        MACOSX("macos"),
        MANAGARM("managarm"),
        MESA3D("mesa3d"),
        NVCL("nvcl"),
        NACL("nacl"),
        NETBSD("netbsd"),
        OPENBSD("openbsd"),
        PS4("ps4"),
        PS5("ps5"),
        RTEMS("rtems"),
        SOLARIS("solaris"),
        SERENITY("serenity"),
        TVOS("tvos"),
        UEFI("uefi"),
        WASI("wasi"),
        WATCHOS("watchos"),
        WIN32("win32", "windows"),
        ZOS("zos"),
        SHADER_MODEL("shadermodel"),
        LITEOS("liteos"),
        XROS("xros", "visionos"),
        VULKAN("vulkan"),
        UNKNOWN("unknown");

        private final String[] names;

        private OperatingSystem(String ... names) {
            this.names = names;
        }

        public String[] getNames() {
            return this.names;
        }

        public static OperatingSystem fromString(String osStr) {
            if (osStr == null || osStr.isEmpty()) {
                return UNKNOWN;
            }
            String osStrLowerCase = osStr.toLowerCase();
            for (OperatingSystem os : OperatingSystem.values()) {
                if (os == UNKNOWN) continue;
                for (String name : os.names) {
                    if (!osStrLowerCase.startsWith(name)) continue;
                    return os;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum Environment {
        ANDROID("android"),
        CODE16("code16"),
        CORECLR("coreclr"),
        CYGNUS("cygnus"),
        EABI("eabi"),
        EABIHF("eabihf"),
        GNU("gnu"),
        GNUT64("gnut64"),
        GNUABI64("gnuabi64"),
        GNUABIN32("gnuabin32"),
        GNUEABI("gnueabi"),
        GNUEABIT64("gnueabit64"),
        GNUEABIHF("gnueabihf"),
        GNUEABIHFT64("gnueabihft64"),
        GNUF32("gnuf32"),
        GNUF64("gnuf64"),
        GNUSF("gnusf"),
        GNUX32("gnux32"),
        GNUILP32("gnuilp32"),
        ITANIUM("itanium"),
        MSVC("msvc"),
        MACABI("macabi"),
        MUSL("musl"),
        MUSLABIN32("muslabin32"),
        MUSLABI64("muslabi64"),
        MUSLEABI("musleabi"),
        MUSLEABIHF("musleabihf"),
        MUSLF32("muslf32"),
        MUSLF("muslf"),
        MUSLX32("muslx32"),
        SIMULATOR("simulator"),
        PIXEL("pixel", "ps"),
        VERTEX("vertex", "vs"),
        GEOMETRY("geometry", "gs"),
        HULL("hull", "hs"),
        DOMAIN("domain", "ds"),
        COMPUTE("compute", "cs"),
        LIBRARY("library", "lib"),
        RAY_GENERATION("raygeneration"),
        INTERSECTION("intersection"),
        ANY_HIT("anyhit"),
        CLOSEST_HIT("closesthit"),
        MISS("miss"),
        CALLABLE("callable"),
        MESH("mesh"),
        AMPLIFICATION("amplification"),
        OPENCL("opencl"),
        OPENHOS("openhos"),
        PAUTHTEST("pauthtest"),
        LLVM("llvm"),
        MLIBC("mlibc"),
        UNKNOWN("unknown");

        private final String[] names;

        private Environment(String ... names) {
            this.names = names;
        }

        public String[] getNames() {
            return this.names;
        }

        public static Environment fromString(String envStr) {
            if (envStr == null || envStr.isEmpty()) {
                return UNKNOWN;
            }
            String envStrLowerCase = envStr.toLowerCase();
            for (Environment env : Environment.values()) {
                if (env == UNKNOWN) continue;
                for (String name : env.names) {
                    if (!envStrLowerCase.startsWith(name)) continue;
                    return env;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum ObjectFormat {
        COFF("coff"),
        ELF("elf"),
        GOFF("goff"),
        MACHO("macho"),
        WASM("wasm"),
        XCOFF("xcoff"),
        DX_CONTAINER("dxcontainer"),
        SPIRV("spirv"),
        UNKNOWN("unknown");

        private final String[] names;

        private ObjectFormat(String ... names) {
            this.names = names;
        }

        public String[] getNames() {
            return this.names;
        }

        public static ObjectFormat fromString(String objFormatStr) {
            if (objFormatStr == null || objFormatStr.isEmpty()) {
                return UNKNOWN;
            }
            String lowerText = objFormatStr.toLowerCase();
            for (ObjectFormat format : ObjectFormat.values()) {
                if (!Arrays.stream(format.names).anyMatch(lowerText::equals)) continue;
                return format;
            }
            return UNKNOWN;
        }
    }
}

