/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.index.configuration.tools.CppcheckConfigurationBase;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.LanguageGroups;
import java.util.Set;

public class CppcheckInternalConfiguration
extends CppcheckConfigurationBase {
    public static final String CPPCHECK_MAPPINGS_TSV = "2_17_1/check-mappings.tsv";
    public static final String VERSION_FILE = "2_17_1/version.txt";
    public static final String DEFAULT_ENABLED_CHECKS_FOR_C_REGEX = ".*";
    private static final Set<String> MISRA_CPP_CHECKS = Set.of("misra-c2012-2.3", "misra-c2012-4.2", "misra-c2012-7.1", "misra-c2012-7.2", "misra-c2012-12.3", "misra-c2012-12.4", "misra-c2012-13.5", "misra-c2012-17.2", "misra-c2012-19.1");
    @ConfigExposed(name="Cppcheck: Enabled Checks for C", description="Regex filter for cppcheck check names that can be run on C code (all checks are executed for C++ code). Checks are executed if the corresponding rule is selected in the analysis profile.", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    public CodeScopeAware<String> enabledChecksForCRegex = CodeScopeAware.defaultCodeScopeWithValue((Object)".*");

    public CppcheckInternalConfiguration() {
        super(EAnalysisTool.CPPCHECK_INTERNAL);
        this.declareCodeScopeAware();
    }

    @Override
    protected String getCppCheckMappingsFile() {
        return CPPCHECK_MAPPINGS_TSV;
    }

    @Override
    protected EAnalysisTool getAnalysisTool() {
        return EAnalysisTool.CPPCHECK_INTERNAL;
    }

    @Override
    protected CodeScopeAware<String> getEnabledChecksForCRegex() {
        return this.enabledChecksForCRegex;
    }

    @Override
    protected Set<ELanguage> getSupportedLanguageForCheck(String checkId) {
        if (MISRA_CPP_CHECKS.contains(checkId)) {
            return LanguageGroups.C_CPP_AND_MS_CLI;
        }
        if (checkId.startsWith("misra-c2012")) {
            return Set.of(ELanguage.C);
        }
        return LanguageGroups.C_CPP_AND_MS_CLI;
    }
}

