/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dashboard;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public abstract class DashboardDescriptorBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    protected @Nullable UUID id;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="group")
    public @Nullable String group;
    @JsonIgnore
    @Deprecated
    public @Nullable String owner;
    @JsonIgnore
    private String descriptorJSON;

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void generateId() {
        this.id = UUID.randomUUID();
    }

    public String getName() {
        return this.name;
    }

    public @Nullable String getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable String owner) {
        this.owner = owner;
    }

    @JsonGetter(value="descriptor")
    public JsonNode getDescriptor() {
        try {
            return JsonUtils.deserializeFromJson((String)this.descriptorJSON);
        }
        catch (JsonSerializationException e) {
            throw new AssertionError("We expect that only valid JSON is stored in the dashboard descriptorJSON field!", e);
        }
    }

    public String getDescriptorAsJson() {
        return this.descriptorJSON;
    }

    @JsonSetter(value="descriptor")
    public void setDescriptor(JsonNode descriptor) {
        this.descriptorJSON = JsonUtils.serializeToJSON((Object)descriptor);
    }
}

