/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.filters.cpp;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class ParameterUnusedAnnotationFilter
implements IFalsePositiveFilter {
    private static final String MAYBE_UNUSED_ANNOTATION = "maybe_unused";
    private static final String GNU_UNUSED_ANNOTATION = "gnu::unused";
    private static final EnumSet<ETokenType> PARAMETER_SEPARATORS = EnumSet.of(ETokenType.COMMA, ETokenType.SEMICOLON, ETokenType.LPAREN, ETokenType.RPAREN);

    @Override
    public boolean isFiltered(String variable, ControlFlowNode statement, ControlFlowGraph controlFlowGraph, List<ShallowEntity> fileEntities, TokenElementInfo element) {
        List<ShallowEntity> allEntities = controlFlowGraph.getEntities();
        if (allEntities.isEmpty()) {
            return false;
        }
        UnmodifiableList entityTokens = allEntities.get(0).includedTokens();
        List maybeUnusedAnnotationIndices = TokenStreamUtils.firstTokenOfTypeSequences((List)entityTokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.LBRACK, ETokenType.LBRACK, ETokenType.IDENTIFIER, ETokenType.RBRACK, ETokenType.RBRACK});
        Iterator iterator = maybeUnusedAnnotationIndices.iterator();
        while (iterator.hasNext()) {
            int unusedAnnotationStartIndex = (Integer)iterator.next();
            if (!this.isMaybeUnusedAnnotation(unusedAnnotationStartIndex + 2, (List<IToken>)entityTokens) || !ParameterUnusedAnnotationFilter.isEqualUnusedVariable(variable, unusedAnnotationStartIndex, (List<IToken>)entityTokens)) continue;
            return true;
        }
        List gnuUnusedAnnotationIndices = TokenStreamUtils.firstTokenOfTypeSequences((List)entityTokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.LBRACK, ETokenType.LBRACK, ETokenType.IDENTIFIER, ETokenType.SCOPE, ETokenType.IDENTIFIER, ETokenType.RBRACK, ETokenType.RBRACK});
        Iterator iterator2 = gnuUnusedAnnotationIndices.iterator();
        while (iterator2.hasNext()) {
            int unusedAnnotationStartIndex = (Integer)iterator2.next();
            if (!this.isGnuUnusedAnnotation(unusedAnnotationStartIndex + 2, (List<IToken>)entityTokens) || !ParameterUnusedAnnotationFilter.isEqualUnusedVariable(variable, unusedAnnotationStartIndex, (List<IToken>)entityTokens)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEqualUnusedVariable(String variable, int unusedAnnotationStartIndex, List<IToken> entityTokens) {
        IToken currentToken;
        int i;
        for (i = unusedAnnotationStartIndex + 5; i < entityTokens.size() && !PARAMETER_SEPARATORS.contains((currentToken = entityTokens.get(i)).getType()); ++i) {
            if (!currentToken.getText().equals(variable)) continue;
            return true;
        }
        for (i = unusedAnnotationStartIndex - 1; i >= 0 && !PARAMETER_SEPARATORS.contains((currentToken = entityTokens.get(i)).getType()); --i) {
            if (!currentToken.getText().equals(variable)) continue;
            return true;
        }
        return false;
    }

    private boolean isMaybeUnusedAnnotation(int index, List<IToken> entityTokens) {
        return entityTokens.get(index).getText().equals(MAYBE_UNUSED_ANNOTATION);
    }

    private boolean isGnuUnusedAnnotation(int index, List<IToken> entityTokens) {
        String identifiersText = entityTokens.get(index).getText() + entityTokens.get(index + 1).getText() + entityTokens.get(index + 2).getText();
        return GNU_UNUSED_ANNOTATION.equals(identifiersText);
    }
}

