/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.filters.cpp;

import com.teamscale.index.dataflow.FilterUnpreprocessedTokenUtils;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.deadstore.DeadStoreAnalysisFindingsCreator;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class ParameterUsedInDisabledPreprocessorAlternativeFilter
implements IFalsePositiveFilter {
    @Override
    public boolean isFiltered(String variable, ControlFlowNode statement, ControlFlowGraph controlFlowGraph, List<ShallowEntity> fileEntities, TokenElementInfo element) throws ConQATException {
        if (!DeadStoreAnalysisFindingsCreator.isFindingOnParameter(statement, element.getLanguage())) {
            return false;
        }
        UnmodifiableList<IToken> unpreprocessedTokens = element.getTokens();
        for (ShallowEntity preprocessedMethodEntity : controlFlowGraph.getEntities()) {
            List<IToken> methodTokensUnpreprocessed = FilterUnpreprocessedTokenUtils.getUnpreprocessedMethodTokens(preprocessedMethodEntity, unpreprocessedTokens);
            List<Integer> parameterReferenceIndices = ParameterUsedInDisabledPreprocessorAlternativeFilter.getReferenceTokens(variable, methodTokensUnpreprocessed);
            for (int referenceIndex : parameterReferenceIndices) {
                boolean isFollowedByAssignment;
                IToken referenceToken = methodTokensUnpreprocessed.get(referenceIndex);
                boolean isRemovedByPreprocessing = !CollectionUtils.anyMatch((Collection)preprocessedMethodEntity.includedTokens(), token -> token.getType() == referenceToken.getType() && token.getOffset() == referenceToken.getOffset() && token.getText().equals(referenceToken.getText()));
                boolean bl = isFollowedByAssignment = referenceIndex + 1 < methodTokensUnpreprocessed.size() && methodTokensUnpreprocessed.get(referenceIndex + 1).getType() == ETokenType.EQEQ;
                if (!isRemovedByPreprocessing || isFollowedByAssignment) continue;
                return true;
            }
        }
        return false;
    }

    private static List<Integer> getReferenceTokens(String variable, List<IToken> methodTokensUnpreprocessed) {
        ArrayList<Integer> referenceIndices = new ArrayList<Integer>();
        for (int i = 0; i < methodTokensUnpreprocessed.size(); ++i) {
            IToken currentToken = methodTokensUnpreprocessed.get(i);
            if (currentToken.getType() != ETokenType.IDENTIFIER || !currentToken.getText().equals(variable) || i != 0 && methodTokensUnpreprocessed.get(i - 1).getType() == ETokenType.SCOPE) continue;
            referenceIndices.add(i);
        }
        return referenceIndices;
    }
}

