/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.structure.CyclomaticComplexityAnalyzer;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.abap.AbapMethodCallRecognizer;
import java.util.List;
import java.util.Optional;

public class CfgComplexityFilter {
    private static final int MIN_STATEMENT_COUNT_FOR_COMPLEX_METHODS = 50;
    private static final double MAX_INVOCATION_PERCENTAGE = 90.0;
    private static final int MAX_STATEMENTS = 3000;
    private static final int MAX_STATEMENT_FIELD_PRODUCT = 20000;
    private static final long MAX_FIELDS_STATEMENTS_COMPLEXITY_PRODUCT = 50000L;

    static Optional<String> getMessageIfTooComplex(ControlFlowGraph controlFlowGraph) {
        List<ShallowEntity> entities = controlFlowGraph.getEntities();
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType(entities, (EShallowEntityType)EShallowEntityType.STATEMENT);
        int statementCount = statements.size();
        if (statementCount < 50) {
            return Optional.empty();
        }
        long invocationStatements = statements.stream().filter(statement -> AbapMethodCallRecognizer.parse((List)statement.ownStartTokens()).isPresent()).count();
        int complexity = CyclomaticComplexityAnalyzer.computeComplexity(entities) + 1;
        if ((double)invocationStatements * 100.0 / (double)statementCount > 90.0) {
            return Optional.of("Long method where over 90.0% of statements are invocation statements.");
        }
        if (controlFlowGraph.getUsedGlobalVariables().size() * statementCount > 20000) {
            return Optional.of("Many used field variables (" + controlFlowGraph.getUsedGlobalVariables().size() + ") AND many statements (" + statementCount + "). Product of these values is greater than 20000");
        }
        if ((long)controlFlowGraph.getUsedGlobalVariables().size() * invocationStatements * (long)complexity > 50000L) {
            return Optional.of("Many used field variables (" + controlFlowGraph.getUsedGlobalVariables().size() + ") AND many invocation statements (" + invocationStatements + ") AND high complexity (" + complexity + "). Product of these values is greater than 50000");
        }
        if (statementCount > 3000) {
            return Optional.of("Very long method (statementCount=" + statementCount + " > 3000");
        }
        return Optional.empty();
    }
}

