/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.analysislocal;

import com.teamscale.index.configuration.ETaintAnalysisOptions;
import com.teamscale.index.dataflow.DataFlowGraph;
import com.teamscale.index.dataflow.DataflowAnalysisBase;
import com.teamscale.index.dataflow.DataflowAnalysisResult;
import com.teamscale.index.dataflow.EDirection;
import com.teamscale.index.dataflow.IDataFlowGraph;
import com.teamscale.index.dataflow.IDataflowFindingsCreator;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.dataflow.taintpropagation.analysislocal.MethodTaintAnalysisInitializer;
import com.teamscale.index.dataflow.taintpropagation.analysislocal.MethodTaintAnalysisNodeHandler;
import com.teamscale.index.dataflow.taintpropagation.analysislocal.MethodTaintGraphGenerationAnalysisState;
import com.teamscale.index.dataflow.taintpropagation.analysislocal.TaintInfluenceMap;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodTaintGraph;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintAnalysisUtils;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphParameter;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphReferenceBase;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphRemoteFunctionCallSource;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.VariableTaintGraphReference;
import eu.cqse.check.framework.util.abap.AbapCheckUtils;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class MethodTaintGraphGenerationAnalysis
extends DataflowAnalysisBase<MethodTaintGraphGenerationAnalysisState, MethodTaintGraphGenerationAnalysisState, DataflowAnalysisResult<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TaintInfluenceMap influenceMap = new TaintInfluenceMap();
    private final boolean isRfcEnabledAbapFile;
    private final EnumSet<ETaintAnalysisOptions> options;
    private ControlFlowGraph analyzedCfg;
    private final Map<ControlFlowGraph, DataflowAnalysisResult<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>>> cfgResultCache;
    private final MethodTaintGraphGenerationAnalysisState infeasibleState = new MethodTaintGraphGenerationAnalysisState(new ControlFlowNode(), "dummyMethodIdentifier");
    private final long commitTimestamp;
    public Optional<String> analysisAbortMessage = Optional.empty();
    private final List<ControlFlowGraph> allGraphs;
    private MethodTaintGraph resultingTaintGraph;
    public static boolean debugAnalysisWasAborted = false;
    public static Map<String, Integer> debugAnalysisIterationPerMethod = new HashMap<String, Integer>();

    public MethodTaintGraphGenerationAnalysis(long commitTimestamp, EnumSet<ETaintAnalysisOptions> options, List<ControlFlowGraph> allGraphs, Map<ControlFlowGraph, DataflowAnalysisResult<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>>> cfgResultCache, boolean isRfcEnabledAbapFile) {
        this.options = options;
        this.commitTimestamp = commitTimestamp;
        this.allGraphs = allGraphs;
        this.cfgResultCache = cfgResultCache;
        this.isRfcEnabledAbapFile = isRfcEnabledAbapFile;
    }

    @Override
    public EDirection getDirection() {
        return EDirection.FORWARD;
    }

    @Override
    protected IDataFlowGraph createDataFlowGraph(ControlFlowGraph controlFlowGraph) {
        return new DataFlowGraph(controlFlowGraph);
    }

    @Override
    protected MethodTaintGraphGenerationAnalysisState getDefaultState(ControlFlowNode node) {
        String methodIdentifier = TaintAnalysisUtils.buildMethodIdentifier(this.getElement().getUniformPath(), this.analyzedCfg.getMethodName());
        return new MethodTaintGraphGenerationAnalysisState(node, methodIdentifier);
    }

    @Override
    protected MethodTaintGraphGenerationAnalysisState transform(ControlFlowNode cfgNode, MethodTaintGraphGenerationAnalysisState inState) {
        SSAcreator ssaCreatorForNode = new SSAcreator(this, cfgNode.getId());
        MethodTaintAnalysisNodeHandler nodeHandler = new MethodTaintAnalysisNodeHandler(this.options, this.infeasibleState, this.getElement(), this.offsetTransformer, this.rawLineOffsetConverter, ssaCreatorForNode, this.analyzedCfg, this.influenceMap);
        MethodTaintGraphGenerationAnalysisState outState = nodeHandler.processNode(cfgNode, inState);
        boolean debug = false;
        if (debug) {
            String location = "no location";
            if (!cfgNode.getTokens().isEmpty()) {
                location = TaintAnalysisUtils.createLocationForTokens(cfgNode.getTokens(), this.element, this.offsetTransformer, this.rawLineOffsetConverter).toString();
            }
            System.out.println("transform on CFG Node " + cfgNode.getId() + ": " + String.valueOf(cfgNode) + "@" + location);
            System.out.println("INPUT State : " + String.valueOf(inState));
            System.out.println("OUTPUT State: " + String.valueOf(outState));
            System.out.println();
        }
        return outState;
    }

    public static Set<TaintGraphReferenceBase> getReferences(Set<String> set, MethodTaintGraphGenerationAnalysisState state, SSAcreator ssaCreator) {
        HashSet<TaintGraphReferenceBase> references = new HashSet<TaintGraphReferenceBase>();
        for (String variableName : set) {
            references.add(MethodTaintGraphGenerationAnalysis.getReference(variableName, state, ssaCreator));
        }
        return references;
    }

    public static TaintGraphReferenceBase getReference(String variableName, MethodTaintGraphGenerationAnalysisState state, SSAcreator ssaCreator) {
        if (state.containsReferenceFor(variableName)) {
            return state.getReferenceFor(variableName);
        }
        VariableTaintGraphReference local = new VariableTaintGraphReference(variableName, ssaCreator.getNextSSA(), TaintGraphReferenceBase.EReferenceType.LOCAL, null, state.getMethodIdentifier());
        state.putReferenceFor(variableName, local);
        return local;
    }

    @Override
    protected Deque<DataflowAnalysisBase.WorkItem> initializeAnalysis(ControlFlowGraph cfg) throws ConQATException {
        this.analyzedCfg = cfg;
        Deque<DataflowAnalysisBase.WorkItem> initialWorkItemStack = super.initializeAnalysis(cfg);
        HashSet<DataflowAnalysisResult<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>>> analyisResultForInitializerMethods = new HashSet<DataflowAnalysisResult<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>>>();
        for (ControlFlowGraph fileCFG : this.allGraphs) {
            DataflowAnalysisResult<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> result;
            if (!fileCFG.isInitializerCode() || (result = this.getCFGAnalyisResult(fileCFG)) == null) continue;
            analyisResultForInitializerMethods.add(result);
        }
        MethodTaintAnalysisInitializer initializer = new MethodTaintAnalysisInitializer(this.getElement(), this.options);
        initializer.initializeAnalysis(cfg, initialWorkItemStack, analyisResultForInitializerMethods);
        return initialWorkItemStack;
    }

    @Override
    public IDataflowFindingsCreator<DataflowAnalysisResult<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>>> createFindingsCreator(List<IFalsePositiveFilter> filters) {
        return IDataflowFindingsCreator.createNoOpFindingCreator();
    }

    @Override
    protected DataflowAnalysisResult<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> getResult(ControlFlowGraph cfg, Map<ControlFlowNode, MethodTaintGraphGenerationAnalysisState> outStates) {
        HashMap finalNodeMap = new HashMap();
        if (outStates.get(cfg.getExitNode()) != null) {
            MethodTaintGraphGenerationAnalysisState finalState = outStates.get(cfg.getExitNode());
            finalNodeMap.put(cfg.getExitNode(), MethodTaintGraph.clearLocalReferences(this.influenceMap.getUnmodifiableInnerMap(), finalState.getUnmodifiableReferenceMap(), finalState.getMethodCallReferences()));
        }
        return new DataflowAnalysisResult<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>>(cfg, finalNodeMap);
    }

    @Override
    protected void finalizeAnalysis(ControlFlowGraph cfg, DataflowAnalysisResult<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> result) {
        Object resultMap = result.getFacts().getSecondMap((Object)cfg.getExitNode());
        if (resultMap == null) {
            resultMap = Collections.emptyMap();
        }
        String methodIdentifier = TaintAnalysisUtils.buildMethodIdentifier(this.getElement().getUniformPath(), cfg.getMethodName());
        boolean rfcSourceGenerationForExporting = this.options.contains((Object)ETaintAnalysisOptions.TREAT_EXPORTING_PARAMETERS_OF_RFC_ENABLED_FUNCTION_MODULES_AS_TAINT_SOURCE);
        boolean rfcSourceGenerationForOthers = this.options.contains((Object)ETaintAnalysisOptions.TREAT_PARAMETERS_OF_RFC_ENABLED_FUNCTION_MODULES_AS_TAINT_SOURCE);
        if ((rfcSourceGenerationForOthers || rfcSourceGenerationForExporting) && this.controlFlowGraph.getEntities().get(0).getSubtype().equals("function") && this.isAbapFileWithRFCEnablement(this.element.getText())) {
            MethodTaintGraphGenerationAnalysis.injectSourceReferencesForFunctionParameters((Map<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>>)resultMap, methodIdentifier, rfcSourceGenerationForOthers, rfcSourceGenerationForExporting);
        }
        this.resultingTaintGraph = MethodTaintGraph.fromMap(methodIdentifier, (Map<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>>)resultMap, this.commitTimestamp);
        this.putCFGAnalyisResult(cfg, result);
    }

    private boolean isAbapFileWithRFCEnablement(String fileContents) {
        return AbapCheckUtils.hasMetaCommentForRfcEnablement((String)fileContents) || this.isRfcEnabledAbapFile;
    }

    private static void injectSourceReferencesForFunctionParameters(Map<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> resultMap, String methodIdentifier, boolean rfcSourceGenerationForOthers, boolean rfcSourceGenerationForExporting) {
        for (Set<TaintGraphReferenceBase> influenceSources : resultMap.values()) {
            List parameterInfluenceSources = CollectionUtils.filter(influenceSources, influenceSource -> influenceSource.getType() == TaintGraphReferenceBase.EReferenceType.PARAMETER && influenceSource.getSsaIndex().equals("0"));
            for (TaintGraphReferenceBase parameterInfluenceSource : parameterInfluenceSources) {
                TaintGraphParameter parameter = (TaintGraphParameter)parameterInfluenceSource;
                if (parameter.hasAnyModifierOf(TaintGraphParameter.EParameterModifier.EXPORTING)) {
                    if (!rfcSourceGenerationForExporting) continue;
                    influenceSources.add(new TaintGraphRemoteFunctionCallSource(parameterInfluenceSource.getReferenceName(), (TextRegionLocation)parameterInfluenceSource.getLocation(), methodIdentifier));
                    continue;
                }
                if (!parameter.hasAnyModifierOf(TaintGraphParameter.EParameterModifier.IMPORTING, TaintGraphParameter.EParameterModifier.CHANGING, TaintGraphParameter.EParameterModifier.TABLES) || !rfcSourceGenerationForOthers) continue;
                influenceSources.add(new TaintGraphRemoteFunctionCallSource(parameterInfluenceSource.getReferenceName(), (TextRegionLocation)parameterInfluenceSource.getLocation(), methodIdentifier));
            }
        }
    }

    public Optional<MethodTaintGraph> getResultingTaintGraph() {
        return Optional.ofNullable(this.resultingTaintGraph);
    }

    @Override
    protected void abortAnalysis(ControlFlowGraph cfg, Map<ControlFlowNode, MethodTaintGraphGenerationAnalysisState> outStates) throws StorageException {
        super.abortAnalysis(cfg, outStates);
        if (this.options.contains((Object)ETaintAnalysisOptions.STORE_PARTIAL_GRAPH_ON_ABORT)) {
            DataflowAnalysisResult<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> result = this.getResult(cfg, outStates);
            this.finalizeAnalysis(cfg, result);
        }
    }

    @Override
    protected boolean addToOutState(MethodTaintGraphGenerationAnalysisState transformationResult, MethodTaintGraphGenerationAnalysisState outputState, ControlFlowNode node) {
        return outputState.addNewReferences(transformationResult, this.influenceMap);
    }

    @Override
    protected boolean isFeasible(MethodTaintGraphGenerationAnalysisState transformationResult) {
        return transformationResult != this.infeasibleState;
    }

    @Override
    protected MethodTaintGraphGenerationAnalysisState getStartingInput(ControlFlowGraph cfg) {
        return this.getDefaultState(this.getStartNode());
    }

    @Override
    protected MethodTaintGraphGenerationAnalysisState join(List<MethodTaintGraphGenerationAnalysisState> states, ControlFlowNode node) {
        String methodIdentifier = TaintAnalysisUtils.buildMethodIdentifier(this.getElement().getUniformPath(), this.analyzedCfg.getMethodName());
        if (states.isEmpty()) {
            return new MethodTaintGraphGenerationAnalysisState(node, methodIdentifier);
        }
        return MethodTaintGraphGenerationAnalysisState.join(states, this.influenceMap);
    }

    @Override
    protected int getMaxIterations() {
        return 600000;
    }

    @Override
    protected long getMaxAnalysisTime() {
        return 300000L;
    }

    @Override
    protected void statistics(int iterations, long millis, boolean success) {
        String timeFormatted = String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(millis), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
        if (millis > 60000L || !success) {
            String optionalAborted = "";
            if (!success) {
                optionalAborted = "(aborted)";
            }
            LOGGER.debug("Long TaintGraphGeneration" + optionalAborted + ": iterations: " + iterations + ", time: " + timeFormatted + ", method: " + this.analyzedCfg.getMethodName());
        }
        if (!success) {
            debugAnalysisWasAborted = true;
            this.analysisAbortMessage = Optional.of("TaintGraphGeneration aborted. Time: " + timeFormatted + "; " + iterations + " iterations");
        }
        debugAnalysisIterationPerMethod.put(TaintAnalysisUtils.buildMethodIdentifier(this.getElement().getUniformPath(), this.analyzedCfg.getMethodName()), iterations);
    }

    private void putCFGAnalyisResult(ControlFlowGraph cfg, DataflowAnalysisResult<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> result) {
        if (!cfg.isInitializerCode()) {
            return;
        }
        this.cfgResultCache.put(cfg, result);
    }

    private DataflowAnalysisResult<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> getCFGAnalyisResult(ControlFlowGraph cfg) {
        return this.cfgResultCache.get(cfg);
    }

    class SSAcreator {
        private int cfgNodeId;
        private int inStatementAssignmentCounter = 0;

        private SSAcreator(MethodTaintGraphGenerationAnalysis this$0, int cfgNodeId) {
            this.cfgNodeId = cfgNodeId;
        }

        String getNextSSA() {
            if (this.inStatementAssignmentCounter == 0) {
                ++this.inStatementAssignmentCounter;
                return String.valueOf(this.cfgNodeId);
            }
            return this.cfgNodeId + "-" + this.inStatementAssignmentCounter++;
        }
    }
}

