/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.analysislocal;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.taintpropagation.analysislocal.AbapTaintSinkRecognizer;
import com.teamscale.index.dataflow.taintpropagation.analysislocal.MethodTaintGraphGenerationAnalysisState;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.ETaintSinkType;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintAnalysisUtils;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphReferenceBase;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphSink;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.LineOffsetConverter;

public class TaintSinkRecognizer {
    private static final Logger LOGGER = LogManager.getLogger();
    static final String VARIABLE_NAME_PLACEHOLDER = "%variableName%";

    private TaintSinkRecognizer() {
    }

    public static PairList<TaintGraphReferenceBase, TaintGraphSink> getSinkRelations(ControlFlowNode node, MethodTaintGraphGenerationAnalysisState state, TokenElementInfo element, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        if (node.isSynthetic() || node.getTokens().isEmpty()) {
            return PairList.emptyPairList();
        }
        return switch (element.getLanguage()) {
            case ELanguage.ABAP -> new AbapTaintSinkRecognizer().getAbapSinkRelations(node, state, element, offsetTransformer, rawLineOffsetConverter);
            default -> PairList.emptyPairList();
        };
    }

    static Optional<Pair<TaintGraphReferenceBase, TaintGraphSink>> getSinkIfKnownVariable(String potentialVariableName, String sinkDescriptionTemplate, MethodTaintGraphGenerationAnalysisState state, List<IToken> sinkStatementTokens, ETaintSinkType type, TokenElementInfo element, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        if (!state.containsReferenceFor(potentialVariableName)) {
            return Optional.empty();
        }
        if (sinkStatementTokens.isEmpty()) {
            throw new IllegalArgumentException("Cannot create sink for empty tokens");
        }
        TaintGraphReferenceBase reference = state.getReferenceFor(potentialVariableName);
        if (reference == null) {
            LOGGER.warn("Did not find reference for read variable " + potentialVariableName + "(" + element.getUniformPath() + ")");
            return Optional.empty();
        }
        String description = sinkDescriptionTemplate.replace(VARIABLE_NAME_PLACEHOLDER, potentialVariableName);
        TaintGraphSink sink = new TaintGraphSink(sinkStatementTokens.get(0), TaintAnalysisUtils.createLocationForTokens(sinkStatementTokens, element, offsetTransformer, rawLineOffsetConverter), potentialVariableName, description, type, state.getMethodIdentifier());
        return Optional.of(new Pair((Object)reference, (Object)sink));
    }

    static Optional<Pair<TaintGraphReferenceBase, TaintGraphSink>> getSinkIfKnownVariableAt(int indexOfPotentialVariableToken, List<IToken> tokens, ETaintSinkType type, String sinkDescriptionTemplate, TokenElementInfo element, MethodTaintGraphGenerationAnalysisState state, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        return TaintSinkRecognizer.getSinkIfKnownVariable(tokens.get(indexOfPotentialVariableToken).getText().toLowerCase(), sinkDescriptionTemplate, state, tokens, type, element, offsetTransformer, rawLineOffsetConverter);
    }

    static PairList<TaintGraphReferenceBase, TaintGraphSink> getSinksForAllReadKnownVariables(ControlFlowNode node, String sinkDescriptionTemplate, MethodTaintGraphGenerationAnalysisState state, TokenElementInfo element, List<IToken> tokens, ETaintSinkType type, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        PairList sinkRelations = new PairList();
        for (String read : node.getReadWriteInfo().getReads()) {
            Optional<Pair<TaintGraphReferenceBase, TaintGraphSink>> optionalSinkRelation = TaintSinkRecognizer.getSinkIfKnownVariable(read, sinkDescriptionTemplate, state, tokens, type, element, offsetTransformer, rawLineOffsetConverter);
            if (!optionalSinkRelation.isPresent()) continue;
            Pair<TaintGraphReferenceBase, TaintGraphSink> sinkRelation = optionalSinkRelation.get();
            sinkRelations.add((Object)((TaintGraphReferenceBase)sinkRelation.getFirst()), (Object)((TaintGraphSink)sinkRelation.getSecond()));
        }
        return sinkRelations;
    }
}

