/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.dependencies.DependencyAnalysisFactory;
import com.teamscale.index.dependencies.IProjectModuleAnalyzer;
import com.teamscale.index.dependencies.ProjectModule;
import com.teamscale.index.dependencies.ProjectModuleIndex;
import com.teamscale.index.resource.BasicTokenElementIndex;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

public class ProjectModuleIndexSynchronizer
extends ChangeProcessorAnalysisStep {
    @DeltaSource(value=BasicTokenElementIndex.class)
    private KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BasicTokenElementIndex contentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ProjectModuleIndex moduleIndex;

    public void execute() throws StorageException {
        PairList values = new PairList();
        for (IProjectModuleAnalyzer moduleAnalyzer : DependencyAnalysisFactory.getProjectModuleAnalyzers()) {
            this.synchronizeModules(moduleAnalyzer, (PairList<String, ProjectModule>)values);
        }
        if (!values.isEmpty()) {
            this.moduleIndex.setProjectModules((PairList<String, ProjectModule>)values);
        }
    }

    private void synchronizeModules(IProjectModuleAnalyzer moduleAnalyzer, PairList<String, ProjectModule> values) throws StorageException {
        List<String> changedKeys;
        List<String> deletedKeys = moduleAnalyzer.filterKeys(this.contentDelta.getDeletedKeysAsStrings());
        if (!deletedKeys.isEmpty()) {
            this.moduleIndex.removeProjectModules(deletedKeys);
        }
        if ((changedKeys = moduleAnalyzer.filterKeys(this.contentDelta.getAddedOrChangedKeysAsStrings())).isEmpty()) {
            return;
        }
        for (BasicTokenElementInfo projectModuleFile : this.contentIndex.getTokenElements(changedKeys)) {
            Optional<ProjectModule> projectModule = moduleAnalyzer.extractModule(projectModuleFile);
            projectModule.ifPresent(module -> values.add((Object)projectModuleFile.getUniformPath(), module));
        }
    }
}

