/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.abap;

import com.teamscale.index.dependencies.DependencyExtractionSettings;
import com.teamscale.index.dependencies.DependencyExtractorBase;
import com.teamscale.index.dependencies.ITypeLookupEnvironment;
import com.teamscale.index.dependencies.abap.AbapCallDependencyExtractor;
import com.teamscale.index.dependencies.abap.AbapGlobalTypeResolutionUtils;
import com.teamscale.index.dependencies.abap.AbapThirdPartyPathsIndex;
import com.teamscale.index.dependencies.abap.AbapTypeExtractor;
import com.teamscale.index.dependencies.type.Type;
import eu.cqse.check.framework.scanner.IToken;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.abap.AbapUtils;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.abap.ParsedAbapElementPath;
import org.conqat.engine.abap.UniqueAbapElementName;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.StringUtils;

public class AbapDependencyCollection {
    public static final String UNKNOWN_PACKAGE_TYPE_PREFIX = "_UNKNOWN_PACKAGE_/";
    private final String uniformPath;
    private final ParsedAbapElementPath parsedUniformPath;
    private final ListMap<String, ElementLocation> dependencies = new ListMap();
    private final boolean includeThirdPartyDependencies;
    private final ITypeLookupEnvironment typeLookupEnvironment;
    private static final Set<String> BUILT_IN_TYPES = new HashSet<String>(Arrays.asList("B", "C", "D", "DECFLOAT16", "DECFLOAT34", "F", "I", "INT8", "N", "P", "S", "STRING", "T", "X", "XSTRING", "INT1", "INT2", "INT4", "DEC", "DF16_DEC", "DF16_RAW", "DF34_DEC", "DF34_RAW", "FLTP", "CHAR", "LCHR", "SSTRING", "RAW", "LRAW", "RAWSTRING", "DATS", "TIMS", "ACCP", "NUMC", "CLNT", "LANG", "CURR", "CUKY", "QUAN", "UNIT", "DF16_SCL", "DF34_SCL", "PREC", "VARC", "ANY", "ANY TABLE", "CLIKE", "CSEQUENCE", "DATA", "DECFLOAT", "HASHED TABLE", "INDEX TABLE", "NUMERIC", "OBJECT", "SIMPLE", "SORTED TABLE", "STANDARD TABLE", "TABLE", "XSEQUENCE"));
    private final AbapThirdPartyPathsIndex abapThirdPartyPathsIndex;
    private final Set<String> ownInnerTypeNames;

    AbapDependencyCollection(String uniformPath, DependencyExtractionSettings settings, ITypeLookupEnvironment typeLookupEnvironment, AbapThirdPartyPathsIndex abapThirdPartyPathsIndex, Set<String> ownInnerTypeNames) throws StorageException {
        this.uniformPath = uniformPath;
        try {
            this.parsedUniformPath = new ParsedAbapElementPath(uniformPath, false);
        }
        catch (ConQATException e) {
            throw new StorageException("Unable to parse path " + uniformPath + " as an ABAP element path", (Throwable)e);
        }
        this.includeThirdPartyDependencies = settings.includeThirdPartyDependencies;
        this.abapThirdPartyPathsIndex = abapThirdPartyPathsIndex;
        this.typeLookupEnvironment = typeLookupEnvironment;
        this.ownInnerTypeNames = ownInnerTypeNames;
    }

    public AbapDependencyCollection(String uniformPath, DependencyExtractionSettings settings, ITypeLookupEnvironment typeLookupEnvironment, AbapThirdPartyPathsIndex abapThirdPartyPathsIndex) throws StorageException {
        this(uniformPath, settings, typeLookupEnvironment, abapThirdPartyPathsIndex, Collections.emptySet());
    }

    void addDependencyToReturnType(AbapCallDependencyExtractor.PotentiallyUnknownType returnType, IToken ... dependencyLocationTokens) throws StorageException {
        TextRegionLocation location = DependencyExtractorBase.createLocation(this.uniformPath, dependencyLocationTokens);
        if (returnType.preciseTypeIsKnown()) {
            this.dependencies.add((Object)returnType.preciseType.getName(), (Object)location);
            return;
        }
        this.addThirdPartyDependencyIfEnabled(returnType.typeName, location, EAbapObjectType.ALL_ABAP_DATA_TYPES);
    }

    public void processTypeReference(String targetName, IToken ... locationTokens) throws StorageException {
        if (StringUtils.startsWithIgnoreCase((String)targetName, (String)"SY-")) {
            return;
        }
        String baseTargetName = AbapDependencyCollection.stripComponentNameFromStructComponentType(targetName);
        Optional<Type> resolvedType = AbapGlobalTypeResolutionUtils.findType(baseTargetName, this.parsedUniformPath, this.typeLookupEnvironment);
        TextRegionLocation location = DependencyExtractorBase.createLocation(this.uniformPath, locationTokens);
        if (resolvedType.isPresent()) {
            this.dependencies.add((Object)resolvedType.get().getName(), (Object)location);
            return;
        }
        this.addThirdPartyDependencyIfEnabled(baseTargetName, location, EAbapObjectType.ALL_ABAP_DATA_TYPES);
    }

    void addDependencyToResolvedType(Type type, IToken locationToken) {
        TextRegionLocation location = DependencyExtractorBase.createLocation(this.uniformPath, locationToken);
        this.dependencies.add((Object)type.getName(), (Object)location);
    }

    private static String stripComponentNameFromStructComponentType(String targetName) {
        return StringUtils.getFirstPart((String)targetName, (char)'-');
    }

    void addDependenciesForTokenTexts(List<Integer> nameIndices, List<IToken> tokens, EnumSet<EAbapObjectType> possibleObjectTypes) throws StorageException {
        for (int nameIndex : nameIndices) {
            this.addDependency(tokens.get(nameIndex), possibleObjectTypes);
        }
    }

    void addDependency(IToken token, EnumSet<EAbapObjectType> possibleObjectTypes) throws StorageException {
        String abapName = AbapGlobalTypeResolutionUtils.getReferencedAbapName(token).toUpperCase();
        this.addDependency(abapName, token, possibleObjectTypes);
    }

    void addDependencyToFunction(String referencedFunctionName, IToken locationToken) throws StorageException {
        TextRegionLocation location = DependencyExtractorBase.createLocation(this.uniformPath, locationToken);
        String uniqueFunctionName = AbapTypeExtractor.createUniqueFunctionIdentifier(referencedFunctionName);
        if (this.typeLookupEnvironment.isKnownType(uniqueFunctionName)) {
            this.dependencies.add((Object)uniqueFunctionName, (Object)location);
        } else {
            this.typeLookupEnvironment.registerUnresolvedType(uniqueFunctionName);
            this.addThirdPartyDependencyIfEnabled(referencedFunctionName, location, EnumSet.of(EAbapObjectType.FMOD));
        }
    }

    public Optional<UniqueAbapElementName> addDependency(String typeName, IToken locationToken, EnumSet<EAbapObjectType> possibleObjectTypes) throws StorageException {
        TextRegionLocation location = DependencyExtractorBase.createLocation(this.uniformPath, locationToken);
        return this.addDependency(typeName, location, possibleObjectTypes);
    }

    public Optional<UniqueAbapElementName> addDependency(String typeName, TextRegionLocation location, EnumSet<EAbapObjectType> possibleObjectTypes) throws StorageException {
        for (EAbapObjectType objectType : possibleObjectTypes) {
            UniqueAbapElementName abapElement = new UniqueAbapElementName(typeName, objectType);
            String uniqueObjectName = abapElement.getUniqueName();
            if (this.typeLookupEnvironment.isKnownType(uniqueObjectName)) {
                this.dependencies.add((Object)uniqueObjectName, (Object)location);
                return Optional.of(abapElement);
            }
            this.typeLookupEnvironment.registerUnresolvedType(uniqueObjectName);
        }
        if (this.typeLookupEnvironment.isKnownType(typeName)) {
            this.dependencies.add((Object)typeName, (Object)location);
        } else {
            this.typeLookupEnvironment.registerUnresolvedType(typeName);
            this.addThirdPartyDependencyIfEnabled(typeName, location, possibleObjectTypes);
        }
        return Optional.empty();
    }

    private void addThirdPartyDependencyIfEnabled(String typeName, TextRegionLocation location, EnumSet<EAbapObjectType> possibleObjectTypes) throws StorageException {
        Map<EAbapObjectType, String> possibleThirdPartyTypePaths;
        if (this.ownInnerTypeNames.contains(typeName.toUpperCase())) {
            return;
        }
        if (!this.includeThirdPartyDependencies) {
            return;
        }
        if (BUILT_IN_TYPES.contains(typeName.toUpperCase())) {
            return;
        }
        String typeObjectName = typeName;
        Matcher m = AbapGlobalTypeResolutionUtils.MEMBER_PATTERN.matcher(typeName);
        if (m.matches()) {
            typeObjectName = m.group(1);
        }
        if ((possibleThirdPartyTypePaths = this.lookupThirdPartyTypePaths(typeObjectName, possibleObjectTypes)).isEmpty()) {
            this.addThirdPartyDependenciesWithoutPackagePath(typeObjectName, location, possibleObjectTypes);
            return;
        }
        this.addThirdPartyDependenciesIncludingPackagePath(typeObjectName, location, possibleThirdPartyTypePaths);
    }

    private void addThirdPartyDependenciesIncludingPackagePath(String typeName, TextRegionLocation location, Map<EAbapObjectType, String> possibleThirdPartyTypePaths) {
        AbapDependencyCollection.filterTypesGroupTypesIfNotUnique(possibleThirdPartyTypePaths);
        for (String thirdPartyTypeName : possibleThirdPartyTypePaths.values()) {
            this.dependencies.add((Object)thirdPartyTypeName, (Object)location);
        }
        if (possibleThirdPartyTypePaths.size() > 1) {
            StringBuilder message = new StringBuilder("Found multiple target types for " + typeName + " in " + location.toLocationString());
            possibleThirdPartyTypePaths.values().forEach(type -> message.append("\n" + type));
            LogManager.getLogger().warn(message.toString());
        }
    }

    private void addThirdPartyDependenciesWithoutPackagePath(String typeName, TextRegionLocation location, EnumSet<EAbapObjectType> possibleObjectTypes) {
        if (possibleObjectTypes.size() == 1) {
            this.dependencies.add((Object)AbapDependencyCollection.getDependencyNameForUnknownObjectOfType(typeName, (EAbapObjectType)possibleObjectTypes.iterator().next()), (Object)location);
        } else {
            this.dependencies.add((Object)AbapDependencyCollection.getDependencyNameForUnknownObjectAndType(typeName), (Object)location);
        }
    }

    private Map<EAbapObjectType, String> lookupThirdPartyTypePaths(String typeName, EnumSet<EAbapObjectType> possibleObjectTypes) throws StorageException {
        if (this.abapThirdPartyPathsIndex == null) {
            return Collections.emptyMap();
        }
        return this.abapThirdPartyPathsIndex.buildThirdPartyTypeNames(typeName, possibleObjectTypes);
    }

    private static void filterTypesGroupTypesIfNotUnique(Map<EAbapObjectType, String> possibleObjectTypes) {
        if (possibleObjectTypes.size() <= 1) {
            return;
        }
        possibleObjectTypes.remove(EAbapObjectType.TYPE);
    }

    public static String getDependencyNameForUnknownObjectOfType(String typeName, EAbapObjectType objectType) {
        return UNKNOWN_PACKAGE_TYPE_PREFIX + new UniqueAbapElementName(AbapUtils.formatAbapIdentifier((String)typeName), objectType).getUniqueName();
    }

    public static String getDependencyNameForUnknownObjectAndType(String typeName) {
        return UNKNOWN_PACKAGE_TYPE_PREFIX + AbapUtils.formatAbapIdentifier((String)typeName);
    }

    public ListMap<String, ElementLocation> getDependencies() {
        return this.dependencies;
    }
}

