/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external;

import java.io.Serializable;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public abstract class ExternalUploadIndexBase<COMMIT extends Serializable>
extends IndexBase
implements IProjectIndex {
    protected static final String COMMIT_KEY = "#-#commit#-#";

    protected ExternalUploadIndexBase(IStore store) {
        super(store);
    }

    public COMMIT getCommitInfo() throws StorageException {
        return (COMMIT)StorageUtils.deserialize((byte[])this.store.getWithString(COMMIT_KEY));
    }

    public void setCommitInfo(COMMIT commitInfo) throws StorageException {
        this.store.putWithString(COMMIT_KEY, StorageUtils.serialize(commitInfo));
    }

    public static <COMMIT extends Serializable> List<COMMIT> loadCommitInfos(CommitLayeringBranchingLayer branchingLayer, List<CommitDescriptor> commits) throws StorageException {
        PairList keys = new PairList();
        commits.forEach(commit -> keys.add((Object)commit.getBranchName(), (Object)commit.getTimestamp()));
        List values = branchingLayer.getValues(keys, StringUtils.stringToBytes((String)COMMIT_KEY));
        return StorageUtils.deserializeValues((List)values);
    }
}

