/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.external_storage.migration.commit_clustering;

import com.google.common.collect.Iterables;
import com.teamscale.index.external.input.external_storage.migration.commit_clustering.CommitAndPartition;
import com.teamscale.index.external.input.external_storage.migration.commit_clustering.CommitCluster;
import com.teamscale.index.external.input.external_storage.migration.commit_clustering.CommitClusteringStrategyBase;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;

public class ClusterByTimestampStrategy
extends CommitClusteringStrategyBase {
    private static final int MOVE_TO_CODE_COMMIT_TOLERANCE_INTERVAL_MILLIS = 500;

    @Override
    protected @Nullable List<CommitCluster> clusterCommitsOnBranch(LinkedList<CommitAndPartition> uploadCommits, @Nullable LinkedList<CommitDescriptor> codeCommits) {
        ArrayList<CommitCluster> commitClusters = new ArrayList<CommitCluster>();
        List<List<CommitAndPartition>> uploadClusters = ClusterByTimestampStrategy.clusterUploads(uploadCommits);
        if (CollectionUtils.isNullOrEmpty(codeCommits)) {
            return ClusterByTimestampStrategy.alwaysUseFirstUploadCommitAsTarget(uploadClusters, commitClusters);
        }
        return ClusterByTimestampStrategy.useCodeCommitOrUploadCommitAsTarget(new LinkedList<CommitDescriptor>(codeCommits), uploadClusters);
    }

    private static List<CommitCluster> useCodeCommitOrUploadCommitAsTarget(@NonNull Queue<CommitDescriptor> codeCommits, List<List<CommitAndPartition>> uploadClusters) {
        CCSMAssert.isNotEmpty(codeCommits, (String)"Need at least one commit");
        CommitDescriptor codeCommit = codeCommits.poll();
        ArrayList<CommitCluster> commitClusters = new ArrayList<CommitCluster>();
        for (List<CommitAndPartition> uploadCluster : uploadClusters) {
            CommitDescriptor firstUploadCommit = uploadCluster.getFirst().commit();
            while (!codeCommits.isEmpty() && codeCommits.peek().getTimestamp() <= firstUploadCommit.getTimestamp()) {
                codeCommit = codeCommits.poll();
            }
            if (Objects.requireNonNull(codeCommit).getTimestamp() < firstUploadCommit.getTimestamp() - 500L) {
                commitClusters.add(new CommitCluster(firstUploadCommit, uploadCluster));
                continue;
            }
            commitClusters.add(new CommitCluster(codeCommit, uploadCluster));
        }
        return commitClusters;
    }

    private static List<CommitCluster> alwaysUseFirstUploadCommitAsTarget(List<List<CommitAndPartition>> uploadClusters, List<CommitCluster> commitClusters) {
        for (List<CommitAndPartition> uploadCluster : uploadClusters) {
            commitClusters.add(new CommitCluster(uploadCluster.getFirst().commit(), uploadCluster));
        }
        return commitClusters;
    }

    private static List<List<CommitAndPartition>> clusterUploads(Queue<CommitAndPartition> uploadCommits) {
        ArrayList<List<CommitAndPartition>> clusteredCommits = new ArrayList<List<CommitAndPartition>>();
        while (!uploadCommits.isEmpty()) {
            CommitAndPartition commitDescriptor = uploadCommits.poll();
            ArrayList<CommitAndPartition> cluster = new ArrayList<CommitAndPartition>();
            cluster.add(commitDescriptor);
            while (!uploadCommits.isEmpty() && ClusterByTimestampStrategy.isDirectSuccessor(uploadCommits.peek(), (CommitAndPartition)Iterables.getLast(cluster))) {
                cluster.add(uploadCommits.poll());
            }
            clusteredCommits.add(cluster);
        }
        return clusteredCommits;
    }

    private static boolean isDirectSuccessor(CommitAndPartition successorCandidate, CommitAndPartition predecessorCandidate) {
        return successorCandidate.commit().getTimestamp() == predecessorCandidate.commit().getTimestamp() + 1L;
    }
}

