/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.status;

import com.teamscale.core.analysis.PeriodicMaintenanceJob;
import com.teamscale.core.analysis.trigger.MaintenanceTriggerBase;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.external.ExternalUploadReportArchiveOption;
import com.teamscale.index.resource.ExternalAnalysisReportArchiveIndex;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.store.StorageException;

@PeriodicMaintenanceJob(cronExpression="0 * * * *")
public class ExternalAnalysisReportArchiveCleanupTrigger
extends MaintenanceTriggerBase {
    public void execute() throws StorageException {
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)this.indexLayer.openGlobalIndex(ServerOptionIndex.class);
        long maxReportArchiveIndexSize = ExternalUploadReportArchiveOption.getMaxReportArchiveIndexSize(serverOptionIndex);
        for (ProjectInfo project : ((ProjectIndex)this.indexLayer.openGlobalIndex(ProjectIndex.class)).getAllProjectInfos()) {
            ExternalAnalysisReportArchiveIndex reportArchiveIndex = (ExternalAnalysisReportArchiveIndex)this.indexLayer.openNonHistorizedProjectIndex(ExternalAnalysisReportArchiveIndex.class, project);
            if (maxReportArchiveIndexSize == 0L) {
                reportArchiveIndex.removeAllEntries();
                continue;
            }
            reportArchiveIndex.reduceToSize(maxReportArchiveIndexSize);
        }
    }
}

