/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.tools;

import com.teamscale.index.architecture.external.ArchitectureUploadInfo;
import com.teamscale.index.architecture.external.ExternalArchitectureUploadIndex;
import com.teamscale.index.external.tools.StoreModifierBase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.persistence.store.util.CompressingStore;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.options.Option;
import org.conqat.lib.commons.string.StringUtils;

public class ExternalArchitectureUploadIndexMinimizer
extends StoreModifierBase {
    public static final SchemaEntry EXTERNAL_ARCHITECTURE_UPLOAD_INDEX_SCHEMA = new SchemaEntry(ExternalArchitectureUploadIndex.class);
    private static final Pattern FINDING_CREATION = Pattern.compile("finding-creation=\"[^\"]*\"");
    private final Set<String> includedArchitectures = new HashSet<String>();
    private String findingCreation = null;

    @Override
    protected Set<String> getChangedStoreNames() {
        return Set.of("external-architecture-uploads");
    }

    @Override
    protected void modifyStore(String storeName, CompressingStore inputStore, CompressingStore outputStore, Map<String, List<ParentedCommitDescriptor>> commitsByBranch) throws StorageException {
        TwoDimHashMap architectureByBranchAndPath = new TwoDimHashMap();
        for (List<ParentedCommitDescriptor> commits : commitsByBranch.values()) {
            int count = 0;
            for (ParentedCommitDescriptor commitDescriptor : commits) {
                ExternalArchitectureUploadIndexMinimizer.printInfo((String)("  Commit " + ++count + " of " + commits.size()));
                ExternalArchitectureUploadIndex index = new ExternalArchitectureUploadIndex(HistoryAccessOption.readTimestamp((String)commitDescriptor.getBranchName(), (long)commitDescriptor.getTimestamp()).createStore((IStore)inputStore, EXTERNAL_ARCHITECTURE_UPLOAD_INDEX_SCHEMA));
                ArchitectureUploadInfo commit = (ArchitectureUploadInfo)index.getCommitInfo();
                ExternalArchitectureUploadIndexMinimizer.printlnCommit("in:  ", commit);
                ExternalArchitectureUploadIndexMinimizer.printlnCommit("out: ", this.rewriteCommit(commit, commitDescriptor, outputStore, (TwoDimHashMap<String, String, String>)architectureByBranchAndPath));
            }
        }
    }

    public static void main(String[] args) {
        LoggingUtils.initLogger();
        ExternalArchitectureUploadIndexMinimizer.execute(ExternalArchitectureUploadIndexMinimizer::new, (String[])args);
    }

    private ArchitectureUploadInfo rewriteCommit(ArchitectureUploadInfo uploadInfo, ParentedCommitDescriptor commit, CompressingStore outputStore, TwoDimHashMap<String, String, String> architectureByBranchAndPath) throws StorageException {
        String branchName = commit.getBranchName();
        String parentBranchName = ExternalArchitectureUploadIndexMinimizer.getParentBranchName(commit);
        List<String> deletedArchitectures = this.calculateDeletedArchitectures(uploadInfo, architectureByBranchAndPath, branchName, parentBranchName);
        ArchitectureUploadInfo newCommit = this.createMinimizedArchitectureUploadCommit(uploadInfo, architectureByBranchAndPath, branchName, parentBranchName, deletedArchitectures);
        ExternalArchitectureUploadIndex outputIndex = new ExternalArchitectureUploadIndex(HistoryAccessOption.readHeadWriteTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()).createStore((IStore)outputStore, EXTERNAL_ARCHITECTURE_UPLOAD_INDEX_SCHEMA));
        outputIndex.setCommitInfo(newCommit);
        return newCommit;
    }

    private static String getParentBranchName(ParentedCommitDescriptor commit) {
        CommitDescriptor firstParentCommit = commit.getFirstParentCommit();
        if (firstParentCommit != null) {
            return firstParentCommit.getBranchName();
        }
        return null;
    }

    private ArchitectureUploadInfo createMinimizedArchitectureUploadCommit(ArchitectureUploadInfo commit, TwoDimHashMap<String, String, String> architectureByBranchAndPath, String branchName, String parentBranchName, List<String> deletedArchitectures) {
        ArrayList<String> architectures = new ArrayList<String>();
        ArrayList<String> uniformPaths = new ArrayList<String>();
        List<String> uniformPathsInCommit = commit.getUniformPaths();
        for (int i = 0; i < uniformPathsInCommit.size(); ++i) {
            String path = uniformPathsInCommit.get(i);
            String architecture = commit.getArchitectures().get(i);
            if (!this.isArchitectureIncluded(path) || parentBranchName != null && !ExternalArchitectureUploadIndexMinimizer.architectureHasChanged(architecture, path, parentBranchName, architectureByBranchAndPath)) continue;
            uniformPaths.add(path);
            String changedArchitecture = this.changeFindingCreation(architecture);
            architectures.add(changedArchitecture);
            architectureByBranchAndPath.putValue((Object)branchName, (Object)path, (Object)changedArchitecture);
        }
        return new ArchitectureUploadInfo(commit.getUsername(), commit.getMessage(), uniformPaths, architectures, deletedArchitectures);
    }

    private static boolean architectureHasChanged(String architecture, String path, String parentBranchName, TwoDimHashMap<String, String, String> architectureByBranchAndPath) {
        return !architecture.equals(architectureByBranchAndPath.getValue((Object)parentBranchName, (Object)path));
    }

    private List<String> calculateDeletedArchitectures(ArchitectureUploadInfo commit, TwoDimHashMap<String, String, String> architectureByBranchAndPath, String branchName, String parentBranchName) {
        ArrayList<String> deletedArchitectures = new ArrayList<String>();
        for (String deletedArchitecturePath : commit.getDeletedArchitectures()) {
            if (!this.isArchitectureIncluded(deletedArchitecturePath) || parentBranchName == null || architectureByBranchAndPath.getValue((Object)parentBranchName, (Object)deletedArchitecturePath) == null) continue;
            architectureByBranchAndPath.remove((Object)branchName, (Object)deletedArchitecturePath);
            deletedArchitectures.add(deletedArchitecturePath);
        }
        return deletedArchitectures;
    }

    private String changeFindingCreation(String architecture) {
        if (this.findingCreation == null) {
            return architecture;
        }
        return StringUtils.replaceAll((String)architecture, (Pattern)FINDING_CREATION, (String)("finding-creation=\"" + this.findingCreation + "\""));
    }

    private boolean isArchitectureIncluded(String architecturePath) {
        return this.includedArchitectures.isEmpty() || this.includedArchitectures.contains(architecturePath);
    }

    @Option(shortName=97, longName="architecture", description="Adds an architecture uniform path that should be kept.")
    public void addIncludedArchitecture(String architecturePath) {
        this.includedArchitectures.add(architecturePath);
    }

    @Option(shortName=99, longName="finding-creation", description="Sets the finding-creation attribute of all included architectures to this value.")
    public void setFindingCreation(String findingCreation) {
        this.findingCreation = findingCreation;
    }

    private static void printlnCommit(String prefix, ArchitectureUploadInfo commit) {
        ExternalArchitectureUploadIndexMinimizer.printInfo((String)("    " + prefix + String.valueOf(commit.getUniformPaths()) + " - " + String.valueOf(commit.getDeletedArchitectures())));
    }
}

