/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.clangtidy.outsourced_analysis.teamscale_server;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.BaseUrlOption;
import com.teamscale.index.findings.CppIncludeHandler;
import com.teamscale.index.findings.CppIntegratedToolUtils;
import com.teamscale.index.findings.CppToolAnalysisTokenElementDetails;
import com.teamscale.index.findings.clangtidy.ClangTidyRunner;
import com.teamscale.index.findings.clangtidy.ClangTidySynchronizer;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.ClangTidyOutsourcedAnalysisHashUtils;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.ClangTidyOutsourcedAnalysisRequestParameters;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.ClangTidyOutsourcedAnalysisUtils;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.IClangTidyOutsourcedAnalysisExecutionServerAPI;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.teamscale_server.ClangTidyOutsourcedAnalysisSessionsIndex;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.CompileCommandIndex;
import com.teamscale.index.resource.FileIncludeLookup;
import com.teamscale.index.resource.SystemIncludeFileCacheIndex;
import com.teamscale.index.resource.SystemIncludeFileLookup;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementIndexCache;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import com.teamscale.index.resource.element_details.IncludePathDetail;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.index.resource.reparsing_dependency.ReparseRequiredIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.LanguageGroups;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class ClangTidyOutsourcedAnalysisPush
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @DeltaSource(value=BasicTokenElementIndex.class, indexName="basic-token-elements")
    private KeyDelta basicTokenElementIndexDelta;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_WRITE)
    private SystemIncludeFileCacheIndex systemIncludeFileCacheIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    private TokenElementIndex tokenElementIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="basic-token-elements")
    private BasicTokenElementIndex basicTokenElementIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="path-lookup")
    private PathLookupIndex pathLookupIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="compile-commands")
    private CompileCommandIndex compileCommandIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ClangTidyOutsourcedAnalysisSessionsIndex requestedAnalysisIndex;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ServerOptionIndex serverOptions;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ExternalCredentialsIndex credentialsProvider;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MetaIndex metaIndex;
    @StepParameter(value="checks")
    public final CodeScopeAware<List<String>> selectedChecks = CodeScopeAware.defaultCodeScopeWithValue(new ArrayList());
    @StepParameter(value="check-options", optional=true)
    public final CodeScopeAware<PairList<String, String>> selectedOptions = CodeScopeAware.defaultCodeScopeWithValue((Object)new PairList());
    @StepParameter(value="enabled-checks-for-c-regex")
    private CodeScopeAware<String> enabledChecksForCRegex;
    private TokenElementIndexCache contentIndexCache = null;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    ReparseRequiredIndex reparseRequiredIndex;

    public void execute() throws Exception {
        ExternalCredentials executionServerCredentials = ClangTidyOutsourcedAnalysisUtils.getClangTidyAnalysisServiceCredentials(this.serverOptions, (IExternalCredentialsProvider)this.credentialsProvider);
        List<TokenElementInfo> elementsToAnalyze = this.determinePathsToAnalyze().stream().filter(element -> ClangTidySynchronizer.CLANG_TIDY_LANGUAGES.contains(element.getLanguage())).toList();
        CodeScopeAware<ClangTidyOutsourcedAnalysisRequestParameters> parametersPerCodeScope = this.buildAnalysisRequestParametersForAddedOrChangedFiles(elementsToAnalyze);
        CodeScopeAware sessionKeysPerCodeScope = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : parametersPerCodeScope.getCodeScopeNames()) {
            ClangTidyOutsourcedAnalysisRequestParameters parameters = (ClangTidyOutsourcedAnalysisRequestParameters)parametersPerCodeScope.getValue(codeScopeName);
            if (!parameters.verifyConsistency()) {
                LOGGER.error("Could not assemble clang-tidy analysis parameters (see earlier error log). Skipping analysis for code scope " + String.valueOf(codeScopeName) + " .");
                continue;
            }
            String sessionKey = this.requestToClangTidyService(parameters, executionServerCredentials);
            sessionKeysPerCodeScope.setValue(codeScopeName, (Object)sessionKey);
        }
        this.requestedAnalysisIndex.storeSessions((CodeScopeAware<String>)sessionKeysPerCodeScope);
    }

    private List<TokenElementInfo> determinePathsToAnalyze() throws StorageException {
        HashSet<String> changedKeys = new HashSet<String>(this.basicTokenElementIndexDelta.getAddedOrChangedKeysAsStrings());
        if (!CppIntegratedToolUtils.isReanalyzeOnHeaderChangeAnalysisDisabled()) {
            changedKeys.addAll(CppIntegratedToolUtils.determineReanalysisRequiredPaths(this.reparseRequiredIndex, this.getSchedulingCommit()));
            changedKeys.removeIf(path -> ClangTidySynchronizer.HEADER_FILE_EXTENSIONS.contains(FileSystemUtils.getFileExtension((String)path)));
        }
        return this.getContentIndexCache().getValues(changedKeys).stream().filter(Objects::nonNull).toList();
    }

    public TokenElementIndexCache getContentIndexCache() throws StorageException {
        if (this.contentIndexCache == null) {
            this.contentIndexCache = new TokenElementIndexCache(this.tokenElementIndex, (List<UniformPath>)CollectionUtils.emptyList());
        }
        return this.contentIndexCache;
    }

    private CodeScopeAware<ClangTidyOutsourcedAnalysisRequestParameters> buildAnalysisRequestParametersForAddedOrChangedFiles(List<TokenElementInfo> elementsToAnalyze) throws StorageException, ExecutionException {
        List<String> analysisSubjectPaths = elementsToAnalyze.stream().map(BasicTokenElementInfo::getUniformPath).toList();
        Map<String, TokenElementInfo> analysisSubjectMap = elementsToAnalyze.stream().collect(Collectors.toMap(BasicTokenElementInfo::getUniformPath, Function.identity()));
        Set<CodeScopeName> relevantCodeScopeNames = analysisSubjectMap.values().stream().map(CodeScopeDetail::getCodeScopeNameFromTokenElement).collect(Collectors.toSet());
        SystemIncludeFileLookup systemIncludeFileLookup = SystemIncludeFileLookup.create(this.metaIndex, this.systemIncludeFileCacheIndex);
        FileIncludeLookup includeLookup = new FileIncludeLookup(this.pathLookupIndex.createPreloadedLookup(), systemIncludeFileLookup);
        CppIncludeHandler includeHandler = new CppIncludeHandler(this.basicTokenElementIndex, this.compileCommandIndex, includeLookup, this.getLockProvider());
        Map<String, Set<CppIncludeHandler.IncludeFile>> relevantIncludedFiles = Collections.synchronizedMap(new HashMap());
        HashMap<String, IncludePathDetail> includePathDetails = new HashMap<String, IncludePathDetail>();
        for (Map.Entry elementEntry : analysisSubjectMap.entrySet()) {
            Optional<IncludePathDetail> includePathDetail = CppIncludeHandler.getIncludePathDetail((TokenElementInfo)((Object)elementEntry.getValue()));
            if (!includePathDetail.isPresent()) continue;
            includePathDetails.put(elementEntry.getKey(), includePathDetail.get());
        }
        List<BasicTokenElementInfo> changedValues = analysisSubjectMap.values().stream().map(element -> element).toList();
        this.executeInParallelBatches(analysisSubjectPaths, batch -> relevantIncludedFiles.putAll(ClangTidyRunner.computeRelevantIncludeFilesMap(changedValues, includeHandler, includePathDetails)), 500);
        CodeScopeAware<Map<ELanguage, String>> selectedChecksPerLanguage = ClangTidySynchronizer.buildCheckSelectorsForCodeScopes(this.selectedChecks, this.enabledChecksForCRegex, relevantCodeScopeNames);
        List<ClangTidyOutsourcedAnalysisRequestParameters.AnalysisSubjectInformation> analysisSubjects = ClangTidyOutsourcedAnalysisPush.buildAnalysisSubjects(analysisSubjectPaths, analysisSubjectMap, selectedChecksPerLanguage, relevantIncludedFiles, includeHandler);
        CodeScopeAware<Map<String, String>> fileContentHashes = this.computeRelevantFileContentHashesPerCodeScope(analysisSubjects, analysisSubjectMap);
        CodeScopeAware<List<String>> globalCompilerArgumentsPerCodeScope = CppIncludeHandler.determineGlobalCompilerIncludeDirArguments(this.metaIndex, relevantCodeScopeNames);
        CodeScopeAware clangTidyOptions = this.selectedOptions.map(PairList::toMap);
        CodeScopeAware parametersPerCodeScope = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : relevantCodeScopeNames) {
            List<ClangTidyOutsourcedAnalysisRequestParameters.AnalysisSubjectInformation> subjectsForCodeScope = analysisSubjects.stream().filter(subject -> CodeScopeDetail.getCodeScopeNameFromTokenElement((BasicTokenElementInfo)analysisSubjectMap.get(subject.uniformPath())).equals((Object)codeScopeName)).toList();
            ClangTidyOutsourcedAnalysisRequestParameters parameters = new ClangTidyOutsourcedAnalysisRequestParameters((List)globalCompilerArgumentsPerCodeScope.getValue(codeScopeName), (Map)selectedChecksPerLanguage.getValue(codeScopeName), (Map)clangTidyOptions.getValue(codeScopeName), subjectsForCodeScope, (Map)fileContentHashes.getValue(codeScopeName));
            parametersPerCodeScope.setValue(codeScopeName, (Object)parameters);
        }
        return parametersPerCodeScope;
    }

    private CodeScopeAware<Map<String, String>> computeRelevantFileContentHashesPerCodeScope(List<ClangTidyOutsourcedAnalysisRequestParameters.AnalysisSubjectInformation> analysisSubjects, Map<String, TokenElementInfo> changedElements) throws StorageException {
        HashMap<String, String> fileContentHashes = new HashMap<String, String>();
        for (ClangTidyOutsourcedAnalysisRequestParameters.AnalysisSubjectInformation analysisSubject : analysisSubjects) {
            String uniformPath = analysisSubject.uniformPath();
            TokenElementInfo element = changedElements.get(uniformPath);
            fileContentHashes.put(uniformPath, ClangTidyOutsourcedAnalysisHashUtils.generateClangTidyFileContentHash(element));
        }
        for (ClangTidyOutsourcedAnalysisRequestParameters.AnalysisSubjectInformation analysisSubject : analysisSubjects) {
            List requiredIncludedPaths = CollectionUtils.map(analysisSubject.includedPaths(), CppIncludeHandler.IncludeFile::uniformPath);
            for (String includedFilePath : requiredIncludedPaths) {
                BasicTokenElementInfo basicElement;
                if (fileContentHashes.containsKey(includedFilePath) || (basicElement = this.basicTokenElementIndex.getTokenElement(includedFilePath)) == null) continue;
                fileContentHashes.put(includedFilePath, ClangTidyOutsourcedAnalysisHashUtils.generateClangTidyFileContentHash(basicElement));
            }
        }
        CodeScopeAware fileContentHashesPerCodeScope = CodeScopeAware.empty();
        for (ClangTidyOutsourcedAnalysisRequestParameters.AnalysisSubjectInformation analysisSubject : analysisSubjects) {
            String subjectUniformPath = analysisSubject.uniformPath();
            TokenElementInfo element = changedElements.get(subjectUniformPath);
            CodeScopeName codeScopeName = CodeScopeDetail.getCodeScopeNameFromTokenElement(element);
            HashMap<String, String> relevantFileHashes = new HashMap<String, String>();
            relevantFileHashes.put(subjectUniformPath, (String)fileContentHashes.get(subjectUniformPath));
            List requiredIncludedPaths = CollectionUtils.map(analysisSubject.includedPaths(), CppIncludeHandler.IncludeFile::uniformPath);
            for (String includedFilePath : requiredIncludedPaths) {
                if (!fileContentHashes.containsKey(includedFilePath)) continue;
                relevantFileHashes.put(includedFilePath, (String)fileContentHashes.get(includedFilePath));
            }
            if (!fileContentHashesPerCodeScope.contains(codeScopeName)) {
                fileContentHashesPerCodeScope.setValue(codeScopeName, new HashMap());
            }
            ((Map)fileContentHashesPerCodeScope.getValue(codeScopeName)).putAll(relevantFileHashes);
        }
        return fileContentHashesPerCodeScope;
    }

    private static @NonNull List<ClangTidyOutsourcedAnalysisRequestParameters.AnalysisSubjectInformation> buildAnalysisSubjects(List<String> addedOrChangedUniformPaths, Map<String, TokenElementInfo> tokenElements, CodeScopeAware<Map<ELanguage, String>> selectedChecksPerLanguage, Map<String, Set<CppIncludeHandler.IncludeFile>> relevantIncludedFiles, CppIncludeHandler includeHandler) throws StorageException {
        ArrayList<ClangTidyOutsourcedAnalysisRequestParameters.AnalysisSubjectInformation> analysisSubjectInformation = new ArrayList<ClangTidyOutsourcedAnalysisRequestParameters.AnalysisSubjectInformation>();
        for (String uniformPath : addedOrChangedUniformPaths) {
            TokenElementInfo element = tokenElements.get(uniformPath);
            if (element == null) {
                LOGGER.warn("Encountered unexpected null in token elements index for path '{}'.", (Object)uniformPath);
                continue;
            }
            ELanguage language = element.getLanguage();
            CodeScopeName codeScopeName = CodeScopeDetail.getCodeScopeNameFromTokenElement(element);
            if (!LanguageGroups.C_AND_DERIVATIVES.contains(language)) {
                LOGGER.trace("Skipping ClangTidy analysis of path '{}', because {} is not in the analyzed languages {}.", new Supplier[]{() -> uniformPath, () -> language, () -> LanguageGroups.C_AND_DERIVATIVES.stream().map(ELanguage::getReadableName).collect(Collectors.joining(", "))});
                continue;
            }
            String enabledChecksForCurrentFile = (String)((Map)selectedChecksPerLanguage.getValue(codeScopeName)).get(language);
            if (enabledChecksForCurrentFile == null || enabledChecksForCurrentFile.isEmpty()) {
                LOGGER.trace("Skipping ClangTidy analysis of path '{}', because no checks are enabled for language {}.", (Object)uniformPath, (Object)language);
                continue;
            }
            CppToolAnalysisTokenElementDetails tokenElementDetails = CppToolAnalysisTokenElementDetails.extractFromTokenElements(tokenElements.values());
            List<String> localCompilerCommands = includeHandler.determineCompilerCommands(element, relevantIncludedFiles.get(uniformPath), tokenElementDetails, false);
            analysisSubjectInformation.add(new ClangTidyOutsourcedAnalysisRequestParameters.AnalysisSubjectInformation(uniformPath, language, relevantIncludedFiles.get(uniformPath), localCompilerCommands));
        }
        return analysisSubjectInformation;
    }

    private String requestToClangTidyService(ClangTidyOutsourcedAnalysisRequestParameters parameters, ExternalCredentials executionServerCredentials) throws StorageException, ServiceCallException {
        LOGGER.debug("Requesting analysis for '{}' infos from external ClangTidy analysis service.", (Object)parameters.analysisSubjectInfos().size());
        IClangTidyOutsourcedAnalysisExecutionServerAPI executionServerInterface = IClangTidyOutsourcedAnalysisExecutionServerAPI.generateServiceClient(executionServerCredentials, LOGGER);
        CommitDescriptor schedulingCommit = this.getSchedulingCommit();
        return executionServerInterface.requestAnalysisAndOpenSession((IProjectId)this.getProjectId(), new UnresolvedCommitDescriptor(schedulingCommit.getBranchName(), schedulingCommit.getTimestamp()), this.readBaseUrlOption(), parameters);
    }

    private String readBaseUrlOption() throws StorageException, ServiceCallException {
        String baseUrl = BaseUrlOption.getBaseUrl((ServerOptionIndex)this.serverOptions);
        if (baseUrl == null) {
            throw new ServiceCallException("Please set the base URL in admin settings. Without a base URL, the external service will not know how to contact Teamscale once the analysis results are available.");
        }
        return baseUrl;
    }
}

