/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.golangcilint;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.index.findings.golangcilint.GoLangCILintException;
import com.teamscale.index.findings.golangcilint.GoLangCILintUtils;
import eu.cqse.check.framework.core.option.EToolCheckOptionType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.commons.util.JsonSerializationException;

public class GoLangCILintConfigurationFile {
    private static final String RUN_PARAMETER = "run";
    private static final String OUTPUT_PARAMETER = "output";
    private static final String LINTERS_PARAMETER = "linters";
    private static final String ENABLED_LINTERS_PARAMETER = "enable";
    private static final String LINTERS_SETTINGS_PARAMETER = "linters-settings";
    @JsonProperty(value="run")
    private Map<String, JsonNode> run;
    @JsonProperty(value="output")
    private Map<String, JsonNode> output;
    @JsonProperty(value="linters")
    private Map<String, Object> linters;
    @JsonProperty(value="linters-settings")
    private Map<String, LinkedHashMap<String, Object>> lintersSettings;

    @JsonCreator
    public GoLangCILintConfigurationFile(@JsonProperty(value="run") Map<String, JsonNode> run, @JsonProperty(value="output") Map<String, JsonNode> output, @JsonProperty(value="linters") Map<String, Object> linters, @JsonProperty(value="linters-settings") Map<String, LinkedHashMap<String, Object>> lintersSettings) {
        this.run = run;
        this.output = output;
        this.linters = linters;
        this.lintersSettings = lintersSettings;
    }

    public void addEnabledLinters(List<String> linterIds) {
        this.linters.put(ENABLED_LINTERS_PARAMETER, linterIds);
    }

    public boolean shouldAddOption(String checkId, String option) {
        if ("goheader".equals(checkId)) {
            if (!this.lintersSettings.containsKey(checkId)) {
                return true;
            }
            LinkedHashMap<String, Object> optionsMap = this.lintersSettings.get("goheader");
            if ("template".equals(option) && !optionsMap.containsKey("template-path")) {
                return true;
            }
            return "template-path".equals(option) && !optionsMap.containsKey("template");
        }
        return true;
    }

    public void addCheckOption(String checkId, String option, String optionValueType, String optionValue) throws GoLangCILintException {
        String valueTypeText;
        if (optionValue == null || "null".equals(optionValue)) {
            return;
        }
        if (!this.lintersSettings.containsKey(checkId)) {
            this.lintersSettings.put(checkId, new LinkedHashMap());
        }
        if ("LIST".equals(valueTypeText = optionValueType.toUpperCase())) {
            valueTypeText = "STRING_LIST";
        }
        if ("JSONNODE".equals(valueTypeText)) {
            valueTypeText = "JSON";
        }
        EToolCheckOptionType valueType = EToolCheckOptionType.valueOf((String)valueTypeText);
        try {
            Object value = GoLangCILintUtils.parseToConfigurationValue(valueType, optionValue);
            this.lintersSettings.get(checkId).put(option, value);
        }
        catch (JsonSerializationException e) {
            throw new GoLangCILintException("Could not add option " + option + " into settings for check " + checkId, (Exception)((Object)e));
        }
    }
}

