/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.cleanup;

import java.io.Serializable;
import java.time.Instant;
import java.util.Optional;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;

@Index(name="work-item-cleanup-index", options={EStorageOption.NO_ROLLBACK, EStorageOption.COMMIT_ISOLATED}, valueClasses={Instant.class, Integer.class})
public class WorkItemCleanupIndex
extends IndexBase
implements IProjectIndexWithDynamicName {
    public static final String INDEX_PLACEHOLDER = "work-item-cleanup-index";
    private String name;

    public WorkItemCleanupIndex(IStore store) {
        super(store);
    }

    public static String buildIndexName(String connectorId) {
        return "work-item-cleanup-index-" + connectorId;
    }

    void setValue(String key, Serializable value) throws StorageException {
        if (value == null) {
            this.store.removeWithString(key);
        } else {
            this.store.putWithString(key, StorageUtils.serialize((Serializable)value));
        }
    }

    <T extends Serializable> Optional<T> getValue(String key, Class<T> expectedType) throws StorageException {
        byte[] value = this.store.getWithString(key);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of((Serializable)expectedType.cast(StorageUtils.deserialize((byte[])value)));
    }

    public void setName(String indexName) {
        this.name = indexName;
    }

    public String getName() {
        return this.name;
    }
}

