/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.gitlab;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.EIssueTracker;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.index.issues.BugTrackerConnectorDescriptorBase;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.cleanup.WorkItemCleanupIndex;
import com.teamscale.index.issues.gitlab.GitLabIssueSynchronizer;
import com.teamscale.index.issues.gitlab.client.GitLabIssueClient;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;

@ConnectorDescriptor
public class GitLabIssueConnectorDescriptor
extends BugTrackerConnectorDescriptorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    @ConfigExposed(name="Project", description="The **global** (numeric) project ID, or the complete path (&lt;namespace&gt;/&lt;projectPath&gt;) of the GitLab project.")
    private String project;
    @ConfigExposed(name="Labels", description="Comma-separated list of labels. Only issues with any of these labels are imported. Leave empty to import all issues.")
    private List<String> labels = Collections.emptyList();

    public GitLabIssueConnectorDescriptor() {
        super(EIssueTracker.GITLAB);
        this.autoExpose();
        this.hideOption("Projects");
        this.hideOption("Custom Fields");
    }

    @Override
    protected void configureIndices(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        super.configureIndices(indexCreator);
        indexCreator.createProjectIndex(WorkItemCleanupIndex.class, WorkItemCleanupIndex.buildIndexName(this.getConnectorIdentifier()));
    }

    @Override
    protected void configureAdditionalIssueTrackerParameters(TriggerBuilder issueTrackerTriggerBuilder) throws ProjectConfigurationException {
        super.configureAdditionalIssueTrackerParameters(issueTrackerTriggerBuilder);
        GitLabIssueConnectorDescriptor.configureGitlabSynchronizerParameters(issueTrackerTriggerBuilder, this.project, this.labels);
        issueTrackerTriggerBuilder.renameIndex("work-item-cleanup-index", WorkItemCleanupIndex.buildIndexName(this.getConnectorIdentifier()));
    }

    @Override
    protected void setProjectsParameter(TriggerBuilder issueTrackerTriggerBuilder) {
    }

    public static void configureGitlabSynchronizerParameters(TriggerBuilder issueTrackerTriggerBuilder, String project, Collection<String> labels) {
        issueTrackerTriggerBuilder.setTriggerParameter("labels", ITriggerParameter.of(labels));
        issueTrackerTriggerBuilder.setTriggerParameter("project", ITriggerParameter.of(Set.of(project)));
    }

    @Override
    protected Class<? extends IssueTrackerSynchronizerBase<?>> getIssueTrackerSynchronizerClass() {
        return GitLabIssueSynchronizer.class;
    }

    @Override
    public void validate() throws ConnectorValidationException {
        GitLabIssueConnectorDescriptor.validate(this.project);
        super.validate();
    }

    protected void validateAccountDetails(String url, String username, String password) throws ConnectorValidationException {
        GitLabIssueConnectorDescriptor.validateAccountDetails(url, password, this.project, this.labels, LOGGER);
    }

    public static void validate(String project) throws ConnectorValidationException {
        if (StringUtils.isEmpty((String)project)) {
            throw new ConnectorValidationException("Missing Project");
        }
    }

    public static void validateAccountDetails(String url, String password, String project, List<String> labels, Logger logger) throws ConnectorValidationException {
        try {
            if (new GitLabIssueClient(url, password, logger).getIssues(project, labels, null).findAny().isEmpty()) {
                throw new ConnectorValidationException("Could not load any issues from '%s' for project %s and labels '%s'.".formatted(url, project, labels));
            }
        }
        catch (ServiceCallException e) {
            if (e.getStatusCode() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                throw new ConnectorValidationException("Unauthorized access to '%s'. Is the authentication information correct?".formatted(url), (Throwable)e);
            }
            if (e.getStatusCode() == Response.Status.FORBIDDEN.getStatusCode()) {
                throw new ConnectorValidationException("Forbidden access to '%s'. Does the user have the necessary permissions?".formatted(url), (Throwable)e);
            }
            throw new ConnectorValidationException("Could not load issues from '%s' for project '%s': %s".formatted(url, project, e.getResponseBody()), (Throwable)e);
        }
    }
}

