/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.jira.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.jira.client.IJiraDataCenterApi;
import com.teamscale.index.issues.jira.client.JiraClient;
import com.teamscale.index.issues.jira.client.JiraInstanceAwareClient;
import com.teamscale.index.issues.jira.model.JiraProject;
import com.teamscale.index.issues.jira.parser.JiraIssueParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.VisibleForTesting;

public class JiraDataCenterClient
extends JiraInstanceAwareClient {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TOTAL_ISSUES_KEY = "total";
    private final IJiraDataCenterApi jira;

    public JiraDataCenterClient(String baseUrl, @Nullable String username, String password, List<String> cookies) {
        super(baseUrl, username, password, cookies);
        this.jira = (IJiraDataCenterApi)JiraDataCenterClient.configureAuthenticationMode(Retrofit.builder((String)baseUrl), username, password).withInteractionLogger(LOGGER).withCookies(cookies).create(IJiraDataCenterApi.class);
    }

    @Override
    protected List<CompletableFuture<String>> createAndStartIssueRetrieverCallables(ExecutorService executor, Set<String> projects, long lastScanTimestamp, UnmodifiableList<String> fieldsToFetch, Set<String> issueTypes) throws ServiceCallException, CompletionException {
        String jqlQuery = JiraDataCenterClient.createIssueQueryString(projects, lastScanTimestamp, issueTypes);
        int totalIssues = this.getTotalIssuesCount(jqlQuery);
        LOGGER.info("Issues to retrieve: {}", (Object)totalIssues);
        if (totalIssues == 0) {
            return new ArrayList<CompletableFuture<String>>();
        }
        ArrayList<CompletableFuture<String>> futures = new ArrayList<CompletableFuture<String>>();
        PairList<Integer, Integer> issueBatches = JiraDataCenterClient.getIssueBatchOffsetsToFetch(totalIssues);
        for (Pair issueBatch : issueBatches) {
            futures.add(CompletableFuture.supplyAsync(() -> {
                try {
                    return this.retrieveIssues(projects, (Integer)issueBatch.getFirst(), (Integer)issueBatch.getSecond(), lastScanTimestamp, fieldsToFetch, issueTypes);
                }
                catch (ServiceCallException e) {
                    throw new CompletionException(e);
                }
            }, executor));
        }
        return futures;
    }

    @VisibleForTesting
    static PairList<Integer, Integer> getIssueBatchOffsetsToFetch(int totalIssues) {
        PairList offsets = new PairList();
        for (int start = 0; start < totalIssues; start += ISSUE_CHUNK_SIZE.intValue()) {
            int end = Math.min(start + ISSUE_CHUNK_SIZE, totalIssues);
            offsets.add(new Pair((Object)start, (Object)end));
        }
        return offsets;
    }

    private String retrieveIssues(Set<String> projects, int issueStartIndex, int issueEndIndex, long lastScanTimestamp, UnmodifiableList<String> fieldsToFetch, Set<String> issueTypes) throws ServiceCallException {
        String issueQueryString = JiraDataCenterClient.createIssueQueryString(projects, lastScanTimestamp, issueTypes);
        LOGGER.debug("Retrieving issues for query string {} with issue start index {} up to {}", (Object)issueQueryString, (Object)issueStartIndex, (Object)issueEndIndex);
        return this.getIssues(issueQueryString, issueStartIndex, issueEndIndex - issueStartIndex, (List<String>)fieldsToFetch);
    }

    @Override
    public Map<String, String> getProjectNamesByKey() throws ServiceCallException {
        return Retrofit.executeServiceCall(this.jira.getProjects()).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(JiraProject::key, JiraProject::name));
    }

    private int getTotalIssuesCount(String jqlQuery) throws ServiceCallException {
        int n;
        block8: {
            LOGGER.traceEntry("Retrieving the total number of issues for the query: '{}'", new Object[]{jqlQuery});
            ResponseBody responseBody = (ResponseBody)Retrofit.executeServiceCall(this.jira.getIssues(jqlQuery, 0, 0, null, "")).orElseThrow(JiraClient::createEmptyResponseException);
            try {
                n = (Integer)LOGGER.traceExit("Total number of issues: {}", (Object)JiraDataCenterClient.extractTotalIssuesFromJson(responseBody.string()));
                if (responseBody == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (responseBody != null) {
                        try {
                            responseBody.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ServiceCallException((Throwable)e);
                }
            }
            responseBody.close();
        }
        return n;
    }

    private static int extractTotalIssuesFromJson(@Language(value="JSON") String json) throws ServiceCallException {
        JsonNode totalIssuesElement = JiraDataCenterClient.parseJsonNode(json).get(TOTAL_ISSUES_KEY);
        if (totalIssuesElement == null) {
            throw new ServiceCallException("No information about totals found in returned json (truncated): " + StringUtils.truncateWithThreeDots((String)json, (int)50));
        }
        return totalIssuesElement.asInt();
    }

    private static JsonNode parseJsonNode(@Language(value="JSON") String json) throws ServiceCallException {
        try {
            return JiraIssueParser.parseJson(json);
        }
        catch (BugTrackerException e) {
            throw new ServiceCallException("Failed to parse issues JSON.", (Throwable)e);
        }
    }

    private String getIssues(String jql, int startAt, int maxResults, List<String> fieldsToFetch) throws ServiceCallException {
        String string;
        block8: {
            ResponseBody responseBody = (ResponseBody)Retrofit.executeServiceCall(this.jira.getIssues(jql, startAt, maxResults, String.join((CharSequence)",", FIELDS_TO_EXPAND), String.join((CharSequence)",", fieldsToFetch))).orElseThrow(JiraClient::createEmptyResponseException);
            try {
                string = responseBody.string();
                if (responseBody == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (responseBody != null) {
                        try {
                            responseBody.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ServiceCallException((Throwable)e);
                }
            }
            responseBody.close();
        }
        return string;
    }
}

